% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{ants_apply_transforms}
\alias{ants_apply_transforms}
\title{Apply a transform list to map an image from one domain to another}
\usage{
ants_apply_transforms(
  fixed,
  moving,
  transformlist,
  interpolator = c("linear", "nearestNeighbor", "gaussian", "genericLabel", "bSpline",
    "cosineWindowedSinc", "welchWindowedSinc", "hammingWindowedSinc",
    "lanczosWindowedSinc"),
  imagetype = 0L,
  whichtoinvert = NULL,
  compose = NULL,
  defaultvalue = 0,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{fixed}{fixed image defining domain into which the moving image is transformed}

\item{moving}{moving image to be mapped to fixed space}

\item{transformlist}{list of strings (path to transforms) generated by
\code{\link{ants_registration}} where each transform is a file name}

\item{interpolator}{how to interpolate the image; see 'Usage'}

\item{imagetype}{integer: 0 (scalar), 1 (vector), 2 (tensor), 3 (time-series),
used when the fixed and moving images have different mode (dimensions)}

\item{whichtoinvert}{either \code{NULL}, \code{None} ('Python'), or a vector
of logical with same length as \code{transformlist}; print
\code{ants$apply_transforms} to see detailed descriptions}

\item{compose}{optional character pointing to a valid file location}

\item{defaultvalue}{numerical value for mappings outside the image domain}

\item{verbose}{whether to verbose application of transform}

\item{...}{must be named arguments passing to further methods}
}
\value{
Transformed image. The image will share the same space as \code{fixed}.
}
\description{
See \code{ants$apply_transforms} for more details.
}
\examples{

if(interactive() && ants_available()) {
  ants <- load_ants()
  fixed <- as_ANTsImage( ants$get_ants_data('r16') )
  moving <- as_ANTsImage( ants$get_ants_data('r64') )
  fixed <- ants_resample_image(fixed, c(64, 64), TRUE, "linear")
  moving <- ants_resample_image(moving, c(64,64), TRUE, "linear")

  mytx <- ants_registration(fixed = fixed,
                            moving = moving,
                            type_of_transform = 'SyN')
  mywarpedimage <- ants_apply_transforms(
    fixed = fixed,
    moving = moving,
    transformlist = mytx$fwdtransforms
  )

  par(mfrow = c(1,3), mar = c(0,0,3,0))
  pal <- gray.colors(256)
  image(fixed[], asp = 1, axes = FALSE, col = pal,
        ylim = c(1, 0), main = "Reference")
  image(moving[], asp = 1, axes = FALSE, col = pal,
        ylim = c(1, 0), main = "Moving")
  image(mywarpedimage[], asp = 1, axes = FALSE, col = pal,
        ylim = c(1, 0), main = "Moving reg+resamp into Reference")
}

}
\seealso{
\code{print(ants$apply_transforms)}
}
