% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_utilities.R
\name{utilitiesForPiecewiseExponentialDistribution}
\alias{utilitiesForPiecewiseExponentialDistribution}
\alias{getPiecewiseExponentialDistribution}
\alias{ppwexp}
\alias{getPiecewiseExponentialQuantile}
\alias{qpwexp}
\alias{getPiecewiseExponentialRandomNumbers}
\alias{rpwexp}
\title{The Piecewise Exponential Distribution}
\usage{
getPiecewiseExponentialDistribution(
  time,
  ...,
  piecewiseSurvivalTime = NA_real_,
  piecewiseLambda = NA_real_,
  kappa = 1
)

ppwexp(t, ..., s = NA_real_, lambda = NA_real_, kappa = 1)

getPiecewiseExponentialQuantile(
  quantile,
  ...,
  piecewiseSurvivalTime = NA_real_,
  piecewiseLambda = NA_real_,
  kappa = 1
)

qpwexp(q, ..., s = NA_real_, lambda = NA_real_, kappa = 1)

getPiecewiseExponentialRandomNumbers(
  n,
  ...,
  piecewiseSurvivalTime = NA_real_,
  piecewiseLambda = NA_real_,
  kappa = 1
)

rpwexp(n, ..., s = NA_real_, lambda = NA_real_, kappa = 1)
}
\arguments{
\item{...}{Ensures that all arguments after \code{time} are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{kappa}{The kappa value. Is needed for the specification of the Weibull distribution. 
In this case, no piecewise definition is possible, i.e., 
only lambda and kappa need to be specified.
This function is equivalent to pweibull(t, kappa, 1 / lambda) of the R core system, i.e., 
the scale parameter is 1 / 'hazard rate'.
For example, getPiecewiseExponentialDistribution(time = 130, 
piecewiseLambda = 0.01, kappa = 4.2) and 
pweibull(q = 130, shape = 4.2, scale = 1 /0.01) provide the sample result.}

\item{t, time}{Vector of time values.}

\item{s, piecewiseSurvivalTime}{Vector of start times defining the "time pieces".}

\item{lambda, piecewiseLambda}{Vector of lambda values (hazard rates) corresponding to the start times.}

\item{q, quantile}{Vector of quantiles.}

\item{n}{Number of observations.}
}
\description{
Distribution function, quantile function and random number generation for the 
piecewise exponential distribution.
}
\details{
\code{getPiecewiseExponentialDistribution} (short: \code{ppwexp}), 
\code{getPiecewiseExponentialQuantile} (short: \code{qpwexp}), and 
\code{getPiecewiseExponentialRandomNumbers} (short: \code{rpwexp}) provide 
probabilities, quantiles, and random numbers according to a piecewise 
exponential or a Weibull distribution.
The piecewise definition is performed through a vector of 
starting times (\code{piecewiseSurvivalTime}) and a vector of hazard rates (\code{piecewiseLambda}).
You can also use a list that defines the starting times and piecewise 
lambdas together and define piecewiseSurvivalTime as this list.
The list needs to have the form, for example, 
piecewiseSurvivalTime <- list(
    "0 - <6"   = 0.025, 
    "6 - <9"   = 0.04, 
    "9 - <15"  = 0.015, 
    ">=15"      = 0.007) 
For the Weibull case, you can also specify a shape parameter kappa in order to 
calculated probabilities, quantiles, or random numbers.
In this case, no piecewise definition is possible, i.e., only piecewiseLambda and 
kappa need to be specified.
}
\examples{

# Calculate probabilties for a range of time values for a 
# piecewise exponential distribution with hazard rates 
# 0.025, 0.04, 0.015, and 0.007 in the intervals 
# [0, 6), [6, 9), [9, 15), [15,Inf), respectively,
# and re-return the time values: 
piecewiseSurvivalTime <- list(
    "0 - <6"   = 0.025, 
    "6 - <9"   = 0.04, 
    "9 - <15"  = 0.015, 
    ">=15"     = 0.01)
y <- getPiecewiseExponentialDistribution(seq(0, 150, 15), 
    piecewiseSurvivalTime = piecewiseSurvivalTime)
getPiecewiseExponentialQuantile(y, 
    piecewiseSurvivalTime = piecewiseSurvivalTime)

}
