% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.SO3}
\alias{plot.Q4}
\title{Visualizing random rotations}
\usage{
\method{plot}{SO3}(
  x,
  center = mean(x),
  col = 1,
  to_range = FALSE,
  show_estimates = NULL,
  label_points = NULL,
  mean_regions = NULL,
  median_regions = NULL,
  alp = NULL,
  m = 300,
  interactive = FALSE,
  ...
)

\method{plot}{Q4}(
  x,
  center = mean(x),
  col = 1,
  to_range = FALSE,
  show_estimates = NULL,
  label_points = NULL,
  mean_regions = NULL,
  median_regions = NULL,
  alp = NULL,
  m = 300,
  interactive = FALSE,
  ...
)
}
\arguments{
\item{x}{n rotations in \code{SO3} or \code{Q4} format.}

\item{center}{rotation about which to center the observations.}

\item{col}{integer or vector comprised of 1, 2, 3 indicating which column(s)
to display.  If \code{length(col)>1} then each eyeball is labelled with the
corresponding axis.}

\item{to_range}{logical; if \code{TRUE} only part of the globe relevant to
the data is displayed}

\item{show_estimates}{character vector to specify  which of the four
estimates of the principal direction to show. Possibilities are "all",
"proj.mean", "proj.median", "geom.mean", "geom.median".}

\item{label_points}{vector of labels.}

\item{mean_regions}{character vector to specify which of the three confidence
regions to show for the projected mean.  Possibilities are "all",
"trans.theory","trans.bootstrap, "direct.theory", "direct.bootstrap".}

\item{median_regions}{character vector to specify which of the three
confidence regions to show for the projected median.  Possibilities are
"all", "theory", "bootstrap."}

\item{alp}{alpha level to be used for confidence regions.  See
\code{\link{region}} for more details.}

\item{m}{number of bootstrap replicates to use in bootstrap confidence
regions.}

\item{interactive}{deprecated; \code{sphereplot} was set to be removed from CRAN
and was going to take this package down with it}

\item{...}{parameters passed onto the points layer.}
}
\value{
A visualization of rotation data.
}
\description{
This function produces a static three-dimensional globe onto
which  one of the  columns of the provided sample of rotations is projected.
The data are centered around a user-specified rotation matrix.  The static
plot uses \code{ggplot2}.  Interactive plots are no longer supported.
}
\examples{
r <- rvmises(200, kappa = 1.0)
Rs <- genR(r)
plot(Rs, center = mean(Rs), show_estimates = "proj.mean", shape = 4)

\donttest{
  # Z is computed internally and contains information on depth
  plot(
    Rs,
    center = mean(Rs),
    show_estimates = c("proj.mean", "geom.mean"),
    label_points = sample(LETTERS, 200, replace = TRUE)
 ) +
   ggplot2::aes(size = Z, alpha = Z) +
   ggplot2::scale_size(limits = c(-1, 1), range = c(0.5, 2.5))
}
}
