% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osv_download.R
\name{osv_download}
\alias{osv_download}
\alias{.osv_download}
\alias{.osv_download_cache}
\title{Download vulnerabilities from the OSV database}
\usage{
osv_download(
  vuln_ids = NULL,
  ecosystem,
  parse = TRUE,
  cache = TRUE,
  download_only = FALSE
)

.osv_download(vuln_ids = NULL, ecosystem, parse = TRUE, download_only = FALSE)

.osv_download_cache(
  vuln_ids = NULL,
  ecosystem,
  parse = TRUE,
  download_only = FALSE
)
}
\arguments{
\item{vuln_ids}{Vector of vulnerability IDs (optional).}

\item{ecosystem}{Ecosystem package lives within (must be set).}

\item{parse}{Boolean value to set if the content field should be parsed from JSON list format.}

\item{cache}{Boolean value to determine if should use a cached version of the function and API results.}

\item{download_only}{Boolean value to determine if only the JSON files should be downloaded to disk.}
}
\value{
An R6 object containing API query contents.
}
\description{
Use vulnerability IDs and/or an ecosystem name to download vulnerability files from OSV GCS buckets.
}
\details{
Although the end-result will be similar to the other API functions, this one specifically downloads .zip or
.json files from the OSV GCS buckets. As a result, it has two main benefits. First, it can download the entire set
of vulnerabilities listed for an ecosystem. Second, it has options to save the vulnerability files to disk. The
files are saved to the R session's temp space, as defined by the environment variable \code{ROSV_CACHE_GLOBAL}.

Any ecosystems listed \href{https://osv-vulnerabilities.storage.googleapis.com/ecosystems.txt}{here} can be downloaded.
Only one ecosystem can be provided at a time.
}
\section{Functions}{
\itemize{
\item \code{.osv_download()}: Internal function to run \code{osv_download} without caching.

\item \code{.osv_download_cache()}: Internal function to run a memoise and cached version of \code{osv_download}.

}}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
vulns <- osv_download("RSEC-2023-8", "CRAN")
get_content(vulns)

# Clean up
try(clear_osv_cache())
\dontshow{\}) # examplesIf}
}
