% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prov.R
\docType{methods}
\name{fullprovgraph}
\alias{fullprovgraph}
\alias{fullprovgraph,ProvStoreDF-method}
\alias{fullprovgraph,ProvStoreDF}
\alias{fullprovgraph,data.frame-method}
\alias{fullprovgraph,data.frame}
\title{Create the full (multiple values per variable) provenance
    graph for a cache}
\usage{
fullprovgraph(provstore)

\S4method{fullprovgraph}{ProvStoreDF}(provstore)

\S4method{fullprovgraph}{data.frame}(provstore)
}
\arguments{
\item{provstore}{The provenance store data to use when generating the graph}
}
\value{
an igraph object representing the provenance graph
}
\description{
This generates and returns the \emph{full} provenance
    graph reflecting the information stored in the cache or
    data.frame specified. This can include the same variable
    multiple times if the corresponding expression is run with
    different inputs.
}
\examples{
library(fastdigest)
code = c("x = 5", "y = x + 1")
outvars = c("x", "y")
outvarhashes = c(fastdigest(5), fastdigest(6))
outvarclasses = rep("numeric", 2)
invars = c("", "x")
invarhashes = c("", fastdigest(5))
invarclasses = c("", "numeric")

ps = ProvStoreDF(outvars = outvars,
                 outvarhashes = outvarhashes,
                 outvarclasses = outvarclasses,
                 invars = invars,
                 invarhashes = invarhashes,
                 invarclasses = invarclasses,
                 code = code,
                 agent = "coolguyorgirl")

plot(fullprovgraph(ps))
}
