% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rollup.R
\name{validate_ds}
\alias{validate_ds}
\title{Validates a data set for use with \code{rollup()}}
\usage{
validate_ds(
  tree,
  ds,
  get_keys,
  get_prop,
  op = function(x) is.numeric(x) & !is.na(x)
)
}
\arguments{
\item{tree}{\code{igraph} directed graph that is a valid single-rooted in-tree
and whose vertex names are keys from the data set}

\item{ds}{data set to be updated; can be any object}

\item{get_keys}{function to get keys of the data set called as \code{get_keys(ds)}}

\item{get_prop}{function to get the property value to validate for leaf element with id \code{l}, called as \code{get_prop(ds, l)}}

\item{op}{logical function to test return value of \code{get_prop()} (default \code{is.numeric()}); returns \code{TRUE} if OK}
}
\value{
TRUE if validation succeeds, halts otherwise
}
\description{
\code{validate_ds()} ensures that a data set contains the same identifiers as a specified tree and that
elements of the data set corresponding to leaf vertices in the tree satisfy a user-specified predicate.
}
\examples{
validate_ds(wbs_tree, wbs_table, function(d) d$id, function(d, l) d[d$id == l, "work"])

}
