% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{add_balance_table}
\alias{add_balance_table}
\title{Add the balancing table to the final output}
\usage{
add_balance_table(scored_data, vars, tm, id, combined_output, treat, matches)
}
\arguments{
\item{scored_data}{The dataframe from score_data()}

\item{vars}{See rollmatch()}

\item{tm}{See rollmatch()}

\item{id}{See rollmatch()}

\item{combined_output}{A list of output for the rollmatch package. 
See make_output}

\item{treat}{See rollmatch()}

\item{matches}{Dataframe containing the matches from comparison_pool}
}
\value{
\code{output} returns a list with the additional output:
\item{balance}{The balancing table.}
}
\description{
Add the balancing table to the final output
}
\examples{
\dontrun{
data(package="rollmatch", "rem_synthdata_small")
reduced_data <- reduce_data(data = rem_synthdata_small, treat = "treat",
                            tm = "quarter", entry = "entry_q",
                            id = "indiv_id", lookback = 1)
fm <- as.formula(treat ~ qtr_pmt + yr_pmt + age)
vars <- all.vars(fm)
scored_data <- score_data(model_type = "logistic", match_on = "logit", fm = fm,
                          reduced_data = reduced_data, treat = "treat",
                          tm = "quarter", entry = "entry_q", id = "indiv_id")
comparison_pool <- compare_pool(scored_data, treat = "treat",
                                tm = "quarter", entry = "entry_q",
                                id = "indiv_id")
trimmed_pool <- trim_pool(alpha = .2, comparison_pool = comparison_pool,
                          scored_data = scored_data, treat = "treat",
                          tm = "quarter", standard_deviation = 'average')
matches <- create_matches(trimmed_pool = trimmed_pool, tm = "quarter",
                          num_matches = 3, replacement = TRUE)
matches <- add_matches_columns(matches)
combined_output <- make_output(scored_data = scored_data,
                               data = rem_synthdata_small,
                               matches = matches,
                               treat = "treat", tm = "quarter",
                               entry = "entry_q", id = "indiv_id", lookback = 1)
# Add balance table to the output
output <- add_balance_table(scored_data = scored_data, vars = vars,
                            tm = "quarter", id = "indiv_id",
                            combined_output = combined_output,
                            treat = "treat", matches = matches)
}

}
\keyword{internal}
