% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{trimPool}
\alias{trimPool}
\title{Use a caliper to trim the comparison data to only observations within threshold}
\usage{
trimPool(alpha, data_pool, lr_result, weighted_pooled_stdev = FALSE)
}
\arguments{
\item{alpha}{The pre-specified distance within which to allow matching.
The caliper width is calculated as the \code{alpha} multiplied by the
pooled standard deviation of the propensity scores or the logit of the
propensity scores - depending on the value of \code{match_on}.}

\item{lr_result}{Dataframe of results from model in runModel.}

\item{weighted_pooled_stdev}{Boolean. FALSE for average pooled standard
deviation and TRUE for weighted pooled standard deviation.}

\item{dataPool}{Dataframe of comparison data to be trimmed.}
}
\value{
Dataframe of the trimmed comparisons based on the alpha value
}
\description{
Use a caliper to trim the comparison data to only observations within threshold
}
\examples{
\dontrun{ 
load(url(paste0("https://github.com/RTIInternational/rollmatch/raw/master/",
                 "tests/testthat/lr_result.rda")))
load(url(paste0("https://github.com/RTIInternational/rollmatch/raw/master/",
                "tests/testthat/comparison_pool.rda")))
trimmed_pool <- trimPool(alpha = .2, data_pool = comparison_pool,
                         lr_result = lr_result)
head(trimmed_poll)
}
                         
}
\keyword{internal}
