% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_pcr}
\alias{roll_pcr}
\title{Rolling Principal Component Regressions}
\usage{
roll_pcr(x, y, width, comps = 1:ncol(x), weights = rep(1, width),
  intercept = TRUE, center = FALSE, center_x = center,
  center_y = center, scale = FALSE, scale_x = scale, scale_y = scale,
  min_obs = width, complete_obs = TRUE, na_restore = FALSE,
  parallel_for = c("rows", "cols"))
}
\arguments{
\item{x}{matrix or xts object. Rows are observations and columns are the independent variables.}

\item{y}{matrix or xts object. Rows are observations and columns are the dependent variables.}

\item{width}{integer. Window size.}

\item{comps}{integer vector. Select a subset of principal components.}

\item{weights}{vector. Weights for each observation within a window.}

\item{intercept}{logical. Either \code{TRUE} to include or \code{FALSE} to remove the intercept.}

\item{center}{logical. \code{center = z} is shorthand for \code{center_x = z} and
\code{center_y = z}, where \code{z} is either \code{TRUE} or \code{FALSE}.}

\item{center_x}{logical. If \code{TRUE} then the weighted mean of each \code{x} variable is used,
if \code{FALSE} then zero is used.}

\item{center_y}{logical. Analogous to \code{center_x}.}

\item{scale}{logical. \code{scale = z} is shorthand for \code{scale_x = z} and
\code{scale_y = z}, where \code{z} is either \code{TRUE} or \code{FALSE}.}

\item{scale_x}{logical. If \code{TRUE} then the weighted standard deviation of each \code{x} 
variable is used, if \code{FALSE} then no scaling is done.}

\item{scale_y}{logical. Analogous to \code{scale_x}.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then pairwise is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{parallel_for}{character. Executes a "for" loop in which iterations run in parallel by
\code{rows} or \code{cols}.}
}
\value{
A list containing the following components:
\item{coefficients}{A list of objects with the rolling coefficients for each \code{y}.
An object is the same class and dimension (with an added column for the intercept) as \code{x}.}
\item{r.squared}{A list of objects with the rolling r-squareds for each \code{y}.
An object is the same class as \code{x}.}
}
\description{
A parallel function for computing rolling principal component regressions of time-series data.
}
\details{
The numerical calculations use RcppParallel to parallelize rolling principal component regressions of time-series data. 
RcppParallel provides a complete toolkit for creating safe, portable, high-performance parallel 
algorithms, built on top of the Intel Threading Building Blocks (TBB) and TinyThread libraries.

By default, all the available cores on a machine are used for parallel algorithms. If users are 
either already taking advantage of parallelism or instead want to use a fixed number or proportion of 
threads, then set the number of threads in the RcppParallel package with the 
\code{\link[RcppParallel]{setThreadOptions}} function.
}
\examples{
n_vars <- 10
n_obs <- 1000
x <- matrix(rnorm(n_obs * n_vars), nrow = n_obs, ncol = n_vars)
y <- matrix(rnorm(n_obs), nrow = n_obs, ncol = 1)

# Rolling principal component regressions
result <- roll_pcr(x, y, 252, comps = 1)

# Rolling principal component regressions with exponential decay
weights <- 0.9 ^ (251:0)
result <- roll_pcr(x, y, 252, comps = 1, weights)
}
