% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{replace_string}
\alias{replace_string}
\alias{replace_string.flat_table}
\title{Replace strings}
\usage{
replace_string(ft, attributes, string, replacement)

\method{replace_string}{flat_table}(ft, attributes = NULL, string, replacement = NULL)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{attributes}{A vector of strings, attribute names.}

\item{string}{A character string to replace.}

\item{replacement}{A replacement for matched string.}
}
\value{
A \code{flat_table} object.
}
\description{
Transforms the given attributes by replacing the string values with the
replacement value.
}
\examples{

ft <- flat_table('iris', iris) |>
  replace_string(
    attributes = 'Species',
    string = c('set'),
    replacement = c('Set')
  )

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances_by_comparison}()},
\code{\link{select_instances}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
