% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schemas.R
\name{define_dimension}
\alias{define_dimension}
\alias{define_dimension.star_schema}
\title{Define dimension in a \code{star_schema} object.}
\usage{
define_dimension(schema, dimension, name, attributes)

\method{define_dimension}{star_schema}(schema, dimension = NULL, name = NULL, attributes = NULL)
}
\arguments{
\item{schema}{A \code{star_schema} object.}

\item{dimension}{A \code{dimension_schema} object.}

\item{name}{A string, name of the dimension.}

\item{attributes}{A vector of attribute names.}
}
\value{
A \code{star_schema} object.
}
\description{
Dimensions are part of a \code{star_schema} object. They can be defined directly
as a \code{dimension_schema} object or giving the name and a set of attributes.
}
\examples{

s <- star_schema() |>
  define_dimension(
    name = "when",
    attributes = c(
      "Week Ending Date",
      "WEEK",
      "Year"
    )
  )

s <- star_schema()
d <- dimension_schema(
  name = "when",
  attributes = c(
    "Week Ending Date",
    "WEEK",
    "Year"
  )
)
s <- s |>
  define_dimension(d)
}
\seealso{
\code{\link{star_database}}

Other star schema definition functions: 
\code{\link{define_facts}()},
\code{\link{dimension_schema}()},
\code{\link{fact_schema}()},
\code{\link{star_schema}()}
}
\concept{star schema definition functions}
