% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compression_helper_functions.R
\name{compress_with_sum}
\alias{compress_with_sum}
\alias{compress_with_or}
\title{Vector compression helper functions}
\usage{
compress_with_sum(x)

compress_with_or(x)
}
\arguments{
\item{x}{The vector to compress}
}
\value{
The compressed element
}
\description{
These functions can help when compressing vectors. They always compress
their input (\code{x}) into a single element by various means.
}
\details{
\code{compress_with_sum} computes the sum of the elements, doing its best to
convert all input values to numeric values.
\code{compress_with_or} returns \code{0} if all elements are \code{FALSE}, \code{0}, \code{NA} or
empty character values (\code{""}), and \code{1} otherwise.
}
\examples{
rock::compress_with_sum(c(1, '1', 0));
rock::compress_with_or(c(1, '1', 0));
rock::compress_with_or(c(0, '', 0, FALSE));
}
