% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_addChildCodes.R
\name{recode_addChildCodes}
\alias{recode_addChildCodes}
\title{Add child codes under a parent code}
\usage{
recode_addChildCodes(
  input,
  codes,
  childCodes,
  filter = TRUE,
  output = NULL,
  decisionLabel = NULL,
  justification = NULL,
  justificationFile = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{One of 1) a character string specifying the path to a file
with a source; 2) an object with a loaded source as produced by a call
to \code{\link[=load_source]{load_source()}}; 3) a character string specifying the path to a directory
containing one or more sources; 4) or an object with a list of loaded
sources as produced by a call to \code{\link[=load_sources]{load_sources()}}.}

\item{codes}{A single character value with the code to add the child codes
to.}

\item{childCodes}{A named list with specifying when to add which
child code. Each element of this list is a filtering criterion that will be
passed on to \code{\link[=get_source_filter]{get_source_filter()}} to create the actual filter that
will be applied. The name of each element is the code that will be applied
to utterances matching that filter. When calling \code{recode_addChildCodes()}
for a single source, instead of passing the filtering criterion, it is also
possible to pass a filter (i.e. the result of the call to
\code{\link[=get_source_filter]{get_source_filter()}}), which allows more finegrained control. Note
that these 'child code filters' and the corresponding codes are processed
sequentially in the order specified in \code{childCodes}. Any utterances coded
with the code specified in \code{codes} that do not match with any of the 'child
code filters' specified as the \code{childCodes} elements will remain unchanged.
To create a catch-all ('else') category, pass \code{".*"} or \code{TRUE} as
a filter (see the example).}

\item{filter}{Optionally, a filter to apply to specify a subset of the
source(s) to process (see \code{\link[=get_source_filter]{get_source_filter()}}).}

\item{output}{If specified, the recoded source(s) will be written here.}

\item{decisionLabel}{A description of the (recoding) decision that was taken.}

\item{justification}{The justification for this action.}

\item{justificationFile}{If specified, the justification is appended to
this file. If not, it is saved to the \code{justifier::workspace()}. This can
then be saved or displayed at the end of the R Markdown file or R script
using \code{justifier::save_workspace()}.}

\item{preventOverwriting}{Whether to prevent overwriting existing files
when writing the files to \code{output}.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}
}
\value{
Invisibly, the changed source(s) or source(s) object.
}
\description{
This function conditionally splits a code into multiple codes. Note that you
may want to use \code{\link[=recode_addChildCodes]{recode_addChildCodes()}} instead to not lose the
original coding.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Load example source
loadedExampleSource <- rock::load_source(exampleFile);

### Split a code into two codes, showing progress (the backticks are
### used to be able to specify a name that starts with an underscore)
recoded_source <-
  rock::recode_addChildCodes(
    loadedExampleSource,
    codes="childCode1",
    childCodes = list(
      `_and_` = " and ",
      `_book_` = "book",
      `_else_` = TRUE
    ),
    silent=FALSE
  );
}
