% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cooccurrence_matrix.R
\name{create_cooccurrence_matrix}
\alias{create_cooccurrence_matrix}
\title{Create a co-occurrence matrix}
\usage{
create_cooccurrence_matrix(x, codes = x$convenience$codingLeaves,
  plotHeatmap = FALSE)
}
\arguments{
\item{x}{The parsed source(s) as provided by \code{rock::parse_source} or \code{rock::parse_sources}.}

\item{codes}{The codes to include; by default, takes all codes.}

\item{plotHeatmap}{Whether to plot the heatmap.}
}
\value{
The co-occurrence matrix; a \code{matrix}.
}
\description{
This function creates a co-occurrence matrix based on one or more
coded sources. Optionally, it plots a heatmap, simply by calling
the \code{\link[stats:heatmap]{stats::heatmap()}} function on that matrix.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Parse all example sources in that directory
parsedExamples <- rock::parse_sources(examplePath);

### Create cooccurrence matrix
rock::create_cooccurrence_matrix(parsedExamples);

}
