% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.test_mediation}
\alias{confint.test_mediation}
\alias{confint.boot_test_mediation}
\alias{confint.sobel_test_mediation}
\title{Confidence intervals for (robust) mediation analysis}
\usage{
\method{confint}{boot_test_mediation}(object, parm = NULL,
  level = NULL, type = c("boot", "data"), ...)

\method{confint}{sobel_test_mediation}(object, parm = NULL,
  level = 0.95, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{"\link{test_mediation}"}
containing results from (robust) mediation analysis.}

\item{parm}{an integer, character or logical vector specifying the
coefficients for which to extract or compute confidence intervals, or
\code{NULL} to extract or compute confidence intervals for all coefficients.}

\item{level}{for the \code{"boot_test_mediation"} method, this is ignored
and the confidence level of the bootstrap confidence interval for the
indirect effect is used.  For the other methods, the confidence level of
the confidence intervals to be computed.  The default is to compute 95\%
confidence intervals.}

\item{type}{a character string specifying how to compute the confidence
interval of the effects other than the indirect effect(s).  Possible values
are \code{"boot"} (the default) to compute bootstrap confidence intervals
using the normal approximation (i.e., to assume a normal distribution of the
corresponding effect with the standard deviation computed from the bootstrap
replicates), or \code{"data"} to compute confidence intervals via
statistical theory based on the original data (e.g., based on a
t-distribution the coefficients are estimated via regression).  Note that
this is only relevant for mediation analysis via a bootstrap test, where
the confidence interval of the indirect effect is always computed via a
percentile-based method due to the asymmetry of its distribution.}

\item{\dots}{additional arguments are currently ignored.}
}
\value{
A numeric matrix containing the requested confidence intervals.
}
\description{
Extract or compute confidence intervals for coefficients from (robust)
mediation analysis.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
robust_boot <- test_mediation(BSG2014,
                              x = "ValueDiversity",
                              y = "TeamCommitment",
                              m = "TaskConflict",
                              robust = TRUE)
confint(robust_boot, type = "boot")

# run standard bootstrap test
standard_boot <- test_mediation(BSG2014,
                                x = "ValueDiversity",
                                y = "TeamCommitment",
                                m = "TaskConflict",
                                robust = FALSE)
confint(standard_boot, type = "data")

}
\seealso{
\code{\link{test_mediation}()}, \code{\link[=coef.test_mediation]{coef}()}
}
\author{
Andreas Alfons
}
\keyword{utilities}
