% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinRobust}
\alias{robinRobust}
\title{robinRobust}
\usage{
robinRobust(
  graph,
  graphRandom,
  method = c("walktrap", "edgeBetweenness", "fastGreedy", "louvain", "spinglass",
    "leadingEigen", "labelProp", "infomap", "optimal", "other"),
  FUN = NULL,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  type = c("independent", "dependent"),
  directed = FALSE,
  weights = NULL,
  steps = 4,
  spins = 25,
  e.weights = NULL,
  v.weights = NULL,
  nb.trials = 10
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{graphRandom}{The output of random function.}

\item{method}{The clustering method, one of "walktrap", "edgeBetweenness", 
"fastGreedy", "louvain", "spinglass", "leadingEigen", "labelProp", "infomap",
"optimal".}

\item{FUN}{see \code{\link{methodCommunity}}.}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand".}

\item{type}{The type of robin costruction, dependent or independent data}

\item{directed}{This argument is settable only for "edgeBetweenness" method.}

\item{weights}{this argument is not settable for "infomap" method.}

\item{steps}{this argument is settable only for "leadingEigen"and"walktrap" 
method.}

\item{spins}{This argument is settable only for "infomap" method.}

\item{e.weights}{This argument is settable only for "infomap" method.}

\item{v.weights}{This argument is settable only for "infomap" method.}

\item{nb.trials}{This argument is settable only for "infomap" method.}
}
\value{
A list object.
}
\description{
This functions implements a procedure to examine the stability of the partition recovered by some algorithm 
against random perturbations of the original graph structure.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
robinRobust(graph=graph, graphRandom=graphRandom, method="louvain",
measure="vi",type="independent")
}
