% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polycor.R
\name{polycor}
\alias{polycor}
\title{Robust estimation of polychoric correlation}
\usage{
polycor(
  x,
  y = NULL,
  c = 0.6,
  variance = TRUE,
  constrained = TRUE,
  method = ifelse(constrained, "Nelder-Mead", "L-BFGS-B"),
  maxcor = 0.999,
  tol_thresholds = 0.01,
  init = initialize_param(x, y)
)
}
\arguments{
\item{x}{Vector of integer-valued responses to first item, or contingency table (a \code{"\link[base]{table}"} object).}

\item{y}{Vector of integer-valued responses to second item; only required if \code{x} is not a contingency table.}

\item{c}{Tuning constant that governs robustness; must be in \code{[0, Inf]}. Defaults to 0.6.}

\item{variance}{Shall an estimated asymptotic covariance matrix be returned? Default is \code{TRUE}.}

\item{constrained}{Shall strict monotonicity of thresholds be explicitly enforced by linear constraints? Default is \code{TRUE}.}

\item{method}{Numerical optimization method.}

\item{maxcor}{Maximum absolute correlation (to ensure numerical stability). Default is 0.999.}

\item{tol_thresholds}{Minimum distance between consecutive thresholds (to enforce strict monotonicity); only relevant if \code{constrained = TRUE}. Default is 0.01.}

\item{init}{Initialization of numerical optimization. Default is neutral.}
}
\value{
An object of class \code{"robpolycor"}, which is a list with the following components. 
\describe{
  \item{\code{theahat}}{A vector of estimates for the polychoric correlation coefficient (\code{rho}) as well as thresholds for \code{x} (named \code{a1,a2,...,a_{Kx-1}}) and \code{y} (named \code{b1,b2,...,b_{Ky-1}}).}
  \item{\code{stderr}}{A vector of standard errors for each estimate in \code{theahat}.}
  \item{\code{vcov}}{Estimated asymptotic covariance matrix of \code{theahat}. The matrix \eqn{\Sigma} in the paper (asymptotic covariance matrix of \eqn{\sqrt{N} \hat{\theta}}) can be obtained via \code{vcov * N}, where \code{N} is the sample size.}
  \item{\code{chisq,pval,df}}{Currently \code{NULL}, will in a future release be the test statistic, p-value, and degrees of freedom of a test for bivariate normality.}
  \item{\code{objective}}{Value of minimized loss function.}
  \item{\code{optim}}{Object of class \code{optim}.}
}
}
\description{
Implements to robust estimator of  Welz, Mair and Alfons (2024, \doi{10.48550/arXiv.2407.18835})  for the polychoric correlation model, based on the general theory of C-estimation proposed by Welz (2024, \doi{10.48550/arXiv.2403.11954}).
}
\examples{
## example data
set.seed(123)
x <- sample(c(1,2,3), size = 100, replace = TRUE)
y <- sample(c(1,2,3), size = 100, replace = TRUE)

polycor(x,y)     # robust
polycor_mle(x,y) # non-robust MLE

}
