% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Transformations.R
\name{fcenLRu}
\alias{fcenLRu}
\title{fcenLRu transformation (functional)}
\usage{
fcenLRu(z, z_step, density, p)
}
\arguments{
\item{z}{grid of points defining the abscissa}

\item{z_step}{step of the grid of the abscissa}

\item{density}{grid evaluation of the P-density}

\item{p}{density of the reference measure P}
}
\value{
\item{\code{out}}{grid evaluation of the P-density in unweighted L2(lambda)}
}
\description{
fcenLR[u] transformation: mapping from B2(P) into unweigted L2(lambda)
}
\examples{
# Common example for all transformations - fcenLR, fcenLRp, fcenLRu 
# Example (log normal distribution under the reference P) 
t = seq(1,10, length = 1000)
t_step = diff(t[1:2])

# Log normal density w.r.t. Lebesgue reference measure in B2(lambda)
f = dlnorm(t, meanlog = 1.5, sdlog = 0.5)

# Log normal density w.r.t. Lebesgue reference measure in L2(lambda)
f.fcenLR = fcenLR(t,t_step,f) 

# New reference given by exponential density
p = dexp(t,0.25)/trapzc(t_step,dexp(t,0.25))

# Plot of log normal density w.r.t. Lebesgue reference measure 
# in B2(lambda) together with the new reference density p
matplot(t,f,type="l",las=1, ylab="density",cex.lab=1.2,cex.axis=1.2, 
  col="black",lwd=2,ylim=c(0,0.3),xlab="t")
matlines(t,p,col="blue")
text(2,0.25,"p",col="blue")
text(4,0.22,"f",col="black")

# Log-normal density w.r.t. exponential distribution in B2(P) 
# (unit-integral representation)
fp = (f/p)/trapzc(t_step,f/p)

# Log-normal density w.r.t. exponential distribution in L2(P)
fp.fcenLRp = fcenLRp(t,t_step,fp,p)

# Log-normal density w.r.t. exponential distribution in L2(lambda)
fp.fcenLRu = fcenLRu(t,t_step,fp,p)

# Log-normal density w.r.t. exponential distribution in B2(lambda)
fp.u = fcenLRinv(t,t_step,fp.fcenLRu)

# Plot
layout(rbind(c(1,2,3,4),c(7,8,5,6)))
par(cex=1.1)

plot(t, f.fcenLR, type='l', ylab=expression(fcenLR[lambda](f)), 
  xlab='t',las=1,ylim=c(-3,3),
  main=expression(bold(atop(paste('(a) Representation of f in ', L^2, (lambda)),'[not weighted]'))))
abline(h=0,col="red")

plot(t, f, type='l', ylab=expression(f[lambda]), 
  xlab='t',las=1,ylim=c(0,0.4),
  main=expression(bold(atop(paste('(b) Density f in ', B^2, (lambda)),'[not weighted]'))))

plot(t, fp, type='l', ylab=expression(f[P]), xlab='t',
  las=1,ylim=c(0,0.4),
  main=expression(bold(atop(paste('(c) Density f in ', B^2, (P)),'[weighted with P]'))))

plot(t, fp.fcenLRp, type='l', ylab=expression(fcenLR[P](f[P])), 
  xlab='t',las=1,ylim=c(-3,3), 
  main=expression(bold(atop(paste('(d) Representation of f in ', L^2, (P)),'[weighted with P]'))))
abline(h=0,col="red")

plot(t, fp.u, type='l', ylab=expression(paste(omega^(-1),(f[P]))), 
  xlab='t',las=1,ylim=c(0,0.4), 
  main=expression(bold(atop(paste('(e) Representation of f in ', B^2, (lambda)),'[unweighted]'))))

plot(t, fp.fcenLRu, type='l', ylab=expression(paste(fcenLR[u](f[P]))), 
  xlab='t',las=1,ylim=c(-3,3),
  main=expression(bold(atop(paste('(f) Representation of f in ', L^2, (lambda)),'[unweighted]'))))
abline(h=0,col="red")
}
\references{
Talska, R., Menafoglio, A., Hron, K., Egozcue, J. J., Palarea-Albaladejo, J. (2020). Weighting the domain of probability densities in functional data analysis.\emph{Stat}(2020). https://doi.org/10.1002/sta4.283
}
\author{
R. Talska\email{talskarenata@seznam.cz}, A. Menafoglio, K. Hron\email{karel.hron@upol.cz}, J. J. Egozcue, J. Palarea-Albaladejo
}
