% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdc_locs.r
\name{ncdc_locs}
\alias{ncdc_locs}
\title{Get metadata about NOAA NCDC locations.}
\usage{
ncdc_locs(
  datasetid = NULL,
  locationid = NULL,
  locationcategoryid = NULL,
  startdate = NULL,
  enddate = NULL,
  sortfield = NULL,
  sortorder = NULL,
  limit = 25,
  offset = NULL,
  token = NULL,
  ...
)
}
\arguments{
\item{datasetid}{A valid dataset id or a vector or list of dataset id's. Data returned will be from the
dataset specified, see datasets() (required)}

\item{locationid}{A valid location id or a vector or list of location ids.}

\item{locationcategoryid}{A valid location id or a vector or list of location category ids}

\item{startdate}{A valid ISO formatted date (yyyy-mm-dd). Data returned will have
data after the specified date. Paramater can be use independently of enddate (optional)}

\item{enddate}{Accepts valid ISO formatted date (yyyy-mm-dd). Data returned will have data
before the specified date. Paramater can be use independently of startdate (optional)}

\item{sortfield}{The field to sort results by. Supports id, name, mindate, maxdate, and
datacoverage fields (optional)}

\item{sortorder}{Which order to sort by, asc or desc. Defaults to asc (optional)}

\item{limit}{Defaults to 25, limits the number of results in the response. Maximum is
1000 (optional)}

\item{offset}{Defaults to 0, used to offset the resultlist (optional)}

\item{token}{This must be a valid token token supplied to you by NCDC's
Climate Data Online access token generator. (required) See
\strong{Authentication} section below for more details.}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A list containing metadata and the data, or a single data.frame.
}
\description{
From the NOAA NCDC API docs: Locations can be a specific latitude/longitude
point such as a station, or a label representing a bounding area such as
a city.
}
\section{Authentication}{

Get an API key (aka, token) at \url{http://www.ncdc.noaa.gov/cdo-web/token}.
You can pass your token in as an argument or store it one of two places:

\itemize{
\item your .Rprofile file with an entry like
\code{options(noaakey = "your-noaa-token")}
\item your .Renviron file with an entry like
\code{NOAA_KEY=your-noaa-token}
}

See \code{\link{Startup}} for information on how to create/find your
.Rrofile and .Renviron files
}

\examples{
\dontrun{
# All locations, first 25 results
ncdc_locs()

# Fetch more information about location id FIPS:37
ncdc_locs(locationid='FIPS:37')

# Fetch available locations for the GHCND (Daily Summaries) dataset
ncdc_locs(datasetid='GHCND')
ncdc_locs(datasetid=c('GHCND', 'ANNUAL'))
ncdc_locs(datasetid=c('GSOY', 'ANNUAL'))
ncdc_locs(datasetid=c('GHCND', 'GSOM'))

# Fetch all U.S. States
ncdc_locs(locationcategoryid='ST', limit=52)

# Many locationcategoryid's
## this apparently works, but returns nothing often with multiple
## locationcategoryid's
ncdc_locs(locationcategoryid=c('ST', 'ZIP'))

# Fetch list of city locations in descending order
ncdc_locs(locationcategoryid='CITY', sortfield='name', sortorder='desc')
}
}
\references{
\url{https://www.ncdc.noaa.gov/cdo-web/webservices/v2}
}
\seealso{
Other ncdc: 
\code{\link{ncdc_combine}()},
\code{\link{ncdc_datacats}()},
\code{\link{ncdc_datasets}()},
\code{\link{ncdc_datatypes}()},
\code{\link{ncdc_locs_cats}()},
\code{\link{ncdc_plot}()},
\code{\link{ncdc_stations}()},
\code{\link{ncdc}()}
}
\concept{ncdc}
