% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghcnd.R
\name{ghcnd_stations}
\alias{ghcnd_stations}
\title{Get information on the GHCND weather stations}
\usage{
ghcnd_stations(...)
}
\arguments{
\item{...}{In the case of \code{ghcnd} additional curl options to pass
through to \code{\link[crul]{HttpClient}}. In the case of \code{ghcnd_read}
further options passed on to \code{read.csv}}
}
\value{
This function returns a tibble (dataframe) with a weather
station on each row with the following columns:
\itemize{
\item \code{id}: The weather station's ID number. The first two letters
denote the country (using FIPS country codes).
\item \code{latitude}: The station's latitude, in decimal degrees.
Southern latitudes will be negative.
\item \code{longitude}: The station's longitude, in decimal degrees.
Western longitudes will be negative.
\item \code{elevation}: The station's elevation, in meters.
\item \code{name}: The station's name.
\item \code{gsn_flag}: "GSN" if the monitor belongs to the GCOS Surface
Network (GSN). Otherwise either blank or missing.
\item \code{wmo_id}: If the station has a WMO number, this column gives
that number. Otherwise either blank or missing.
\item \code{element}: A weather variable recorded at some point during
that station's history. See the link below in "References" for definitions
of the abbreviations used for this variable.
\item \code{first_year}: The first year of data available at that station
for that weather element.
\item \code{last_year}: The last year of data available at that station
for that weather element.
}

If a weather station has data on more than one weather variable, it will
be represented in multiple rows of this output dataframe.
}
\description{
This function returns an object with a dataframe with meta-information about
all available GHCND weather stations.
}
\note{
Since this function is pulling a large dataset by ftp, it may take
a while to run.
}
\examples{
\dontrun{
# Get stations, ghcnd-stations and ghcnd-inventory merged
(stations <- ghcnd_stations())

library(dplyr)
# filter by state
stations \%>\% filter(state == "IL")
stations \%>\% filter(state == "OR")
# those without state values
stations \%>\% filter(state == "")
# filter by element
stations \%>\% filter(element == "PRCP")
# filter by id prefix
stations \%>\% filter(grepl("^AF", id))
stations \%>\% filter(grepl("^AFM", id))
# filter by station long name
stations \%>\% filter(name == "CALLATHARRA")
}
}
\references{
For more documentation on the returned dataset, see
\url{http://www1.ncdc.noaa.gov/pub/data/ghcn/daily/readme.txt}.
}
