% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ersst.R
\name{ersst}
\alias{ersst}
\title{NOAA Extended Reconstructed Sea Surface Temperature (ERSST) data}
\usage{
ersst(year, month, overwrite = TRUE, ...)
}
\arguments{
\item{year}{(numeric) A year. Must be > 1853. The max value is whatever
the current year is. Required}

\item{month}{A month, character or numeric. If single digit (e.g. 8), we
add a zero in front (e.g., 08). Required}

\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}. Optional}
}
\value{
An \code{ncdf4} object for now, may change output later to
perhaps a data.frame. See \pkg{ncdf4} for parsing the output.
}
\description{
NOAA Extended Reconstructed Sea Surface Temperature (ERSST) data
}
\section{File storage}{

We use \pkg{rappdirs} to store files, see
\code{\link[rappdirs]{user_cache_dir}} for how we determine the directory on
your machine to save files to, and run
\code{rappdirs::user_cache_dir("rnoaa/ersst")}
to get that directory.

Files are quite small, so we don't worry about reading in cached data to
save time, as we do in some of the other functions in this package.
}

\examples{
\dontrun{
# October, 2015
ersst(year = 2015, month = 10)

# May, 2015
ersst(year = 2015, month = 5)
ersst(year = 2015, month = "05")

# February, 1890
ersst(year = 1890, month = 2)

# Process data
library("ncdf4")
res <- ersst(year = 1890, month = 2)
## varibles
names(res$var)
## get a variable
ncdf4::ncvar_get(res, "ssta")
}
}
\references{
\url{https://www.ncdc.noaa.gov/data-access/marineocean-data/extended-reconstructed-sea-surface-temperature-ersst-v4}
}
