## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ---- eval=TRUE, echo=TRUE, message=FALSE-------------------------------------
library(rnaturalearth)
library(sp)
library(sf)
library(ggplot2)
library(ggrepel)
library(tmap)
library(knitr)


sf_use_s2(FALSE)

## ---- eval=TRUE---------------------------------------------------------------
data(df_layers_physical)
data(df_layers_cultural)

knitr::kable(df_layers_physical, caption = "physical vector data available via ne_download()")
knitr::kable(df_layers_cultural, caption = "cultural vector data available via ne_download()")

## ---- eval=TRUE, echo=TRUE, message=FALSE-------------------------------------
# Africa
terra::plot(ne_countries(continent = "africa"))

sfaf <- ne_countries(continent = "africa", returnclass = "sf")
sfafc <- st_centroid(sfaf)

sfaf <- cbind(sfaf, st_coordinates(st_centroid(sfaf$geometry)))

# G = cbind(G, st_coordinates(st_centroid(G$geometry)))

# this adds centroids in the middle of countries
ggplot(sfaf) +
  geom_sf() +
  geom_sf(data = sfafc)

# trying labels in the middle of countries, doesn't quite work needs x,y,label
# but once x & y added on with st_coordinates ... seems getting the coords might
# not be necessary for much longer https://github.com/slowkow/ggrepel/issues/111
# cool nearly there ...
ggplot(sfaf) +
  geom_sf() +
  geom_text_repel(aes(x = X, y = Y, label = name))

# getting there, labels still overlap a bit maybe make map bigger to allow space
# for labels
ggplot(sfaf) +
  geom_sf() +
  geom_text_repel(aes(x = X, y = Y, label = name_es))

# point.padding=NA allows labels to overlap the centroid
ggplot(sfaf) +
  geom_sf() +
  geom_text_repel(aes(x = X, y = Y, label = name_es), point.padding = NA)

# Africa labels just down left & right sides works pretty well I think
ggplot(sfaf) +
  geom_sf() +
  xlim(-28, 61) +
  geom_text_repel(aes(x = X, y = Y, label = name_es),
    data          = subset(sfaf, X > 21),
    nudge_x       = 60 - subset(sfaf, X > 21)$X,
    segment.size  = 0.2,
    segment.color = "grey50",
    direction     = "y",
    hjust         = 0
  ) +
  geom_text_repel(aes(x = X, y = Y, label = name_es),
    data          = subset(sfaf, X < 21),
    nudge_x       = -19 - subset(sfaf, X < 21)$X,
    segment.size  = 0.2,
    segment.color = "grey50",
    direction     = "y",
    hjust         = 1
  )

# french labels
ggplot(sfaf) +
  geom_sf() +
  xlim(-28, 61) +
  geom_text_repel(aes(x = X, y = Y, label = name_fr),
    data          = subset(sfaf, X > 21),
    nudge_x       = 60 - subset(sfaf, X > 21)$X,
    segment.size  = 0.2,
    segment.color = "grey50",
    direction     = "y",
    hjust         = 0
  ) +
  geom_text_repel(aes(x = X, y = Y, label = name_fr),
    data          = subset(sfaf, X < 21),
    nudge_x       = -19 - subset(sfaf, X < 21)$X,
    segment.size  = 0.2,
    segment.color = "grey50",
    direction     = "y",
    hjust         = 1
  )

# tmap good but labels currently overlap

# english labels
tm_shape(sfaf) +
  tm_borders() +
  tm_text("name")

# spanish labels
tm_shape(sfaf) +
  tm_borders() +
  tm_text("name_es")

# other languages de, fr, nl,
tm_shape(sfaf) +
  tm_borders() +
  tm_text("name_de", size = 0.5)

