% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmargint-fn.R
\name{kernel8}
\alias{kernel8}
\title{Order 8 kernel}
\usage{
kernel8(x)
}
\arguments{
\item{x}{A vector of real numbers.}
}
\value{
A vector of the same length as \code{x} where each entry is \code{( 315/4096 ) * ( 1 - x^2 ) * ( 35 - 385 * x^2 + 1001 * x^4 - 715 * x^6 )} and 0 otherwise.
}
\description{
This function evaluates a kernel of order 8.
}
\details{
This function evaluates a kernel of order 8. A kernel L is a kernel of order 8 if it integrates 1, the integrals of u^j L(u) are 0 for 1 <= j < 8 (j integer) and the integral of u^8 L(u) is different from 0.
}
\examples{
x <- seq(-2,2,length=10)
kernel8(x)
}
\author{
Alejandra Martinez, \email{ale_m_martinez@hotmail.com}, Matias Salibian-Barrera
}
