% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_citations.R
\name{get_citation}
\alias{get_citation}
\alias{get_citation.mgNetwork}
\alias{get_citation.mgNetworksCollection}
\title{Retrieve all references pertaining to the networks collection or individual network}
\usage{
get_citation(x)

\method{get_citation}{mgNetwork}(x)

\method{get_citation}{mgNetworksCollection}(x)
}
\arguments{
\item{x}{an object of class \code{mgNetworksCollection} or \code{mgNetworks}.}
}
\value{
Bibtex entries as a character vector.
}
\description{
Retrieve all references pertaining to the networks collection or individual network
}
\section{Methods (by class)}{
\itemize{
\item \code{mgNetwork}: Get BibTeX entries for the publication associated to the network.

\item \code{mgNetworksCollection}: Get BibTeX entries for the publication associated to the networks.
}}

\examples{
 # network collection
 lagoon_net_collection <- get_collection(search_datasets("lagoon"))
 get_citation(lagoon_net_collection)
 # individual network
 mg_18 <- get_network_by_id(18)
 get_citation(mg_18)

}
