% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splineTimeRFit.R
\name{my_splineDiffExprs}
\alias{my_splineDiffExprs}
\title{Differential expression analysis based on natural cubic spline regression models for time-course data}
\usage{
my_splineDiffExprs(eSetObject, df, cutoff.adj.pVal = 1, reference,
  intercept = TRUE, voom_method = FALSE)
}
\arguments{
\item{eSetObject}{\code{ExpressionSet} object of class \code{ExpressionSet} containing log-ratios or log-values of expression for a series of microarrays}

\item{df}{number of degrees of freedom}

\item{cutoff.adj.pVal}{Benjamini-Hochberg adjusted p-value cut-off}

\item{reference}{character defining which treatment group should be considered as reference}

\item{intercept}{if \code{TRUE}, F-test includes all parameters; if \code{FALSE}, F-test includes shape parameters only; default is \code{TRUE}}

\item{voom_method}{logical value TRUE or FALSE. TRUE when using log-transformed counts, voom-weight, and 75th quantile library size}
}
\value{
a list of 4 components
\item{fit}{output of \code{\link[limma]{lmFit}} function.}
\item{pv}{a vector of p-values of the test for line effect}
\item{qv}{a vector of q-values corresponding to the \code{pv} above.}
\item{diffExprs}{A data.frame with rows defining names/IDs of differentially expressed genes}
}
\description{
This function is a modified version of \code{\link[splineTimeR]{splineDiffExprs}} function
that allows data input as  log-transformed counts taking into account the voom-weights and 75th quantile as library size.
The function compares time dependent behaviour of genes in two different groups.
Applying empirical Bayes moderate F-statistic on differences in coefficients of
fitted natural cubic spline regression models, differentially expressed in time genes are determined.
The function is a wrapper of other R-functions to simplify differential expression analysis of time-course data.
}
\examples{
library(rmRNAseq)
data(design)
data(covset)
data("resSymm")
EE <- 40
DE <- 10
n_idx <- sample(nrow(resSymm$ori.res$v), size = EE + DE)
v <- resSymm$ori.res$v[n_idx,]
newlm <- resSymm$ori.res$newlm[n_idx,]
BetaMat <- data.matrix(newlm[grep("fixed.", names(newlm))])
BetaMat[1:EE, 2] <- 0
BetaMat[(EE+1):(EE+DE), 2] <- BetaMat[(EE+1):(EE+DE), 2]*4
Sigma2Vec <- newlm$s2_shrunken
RhoVec <- data.matrix(newlm[grep("rho.", names(newlm))])
WeightMat <- v$weights
lib.size <- v$targets$lib.size
nrep <- 1
Subject <- covset$ear
Time <- covset$time
counts <- rmRNAseq:::sc_Symm(BetaMat, Sigma2Vec, RhoVec, WeightMat,
lib.size, design, Subject, Time,nrep)
inData <- counts
colnames(inData) <- paste(covset$line, Subject, covset$timef,sep="_")
design <- rmRNAseq::design
design1 <- data.frame(row.names=colnames(inData),
"SampleName"=colnames(inData),
"Time"=covset$time,"Treatment"=covset$line)
phenoData <- new("AnnotatedDataFrame",data=design1)
data <- Biobase::ExpressionSet(assayData=as.matrix(inData),phenoData=phenoData)
diffExprs <- rmRNAseq:::my_splineDiffExprs(eSetObject = data, df = 3,cutoff.adj.pVal = 1,
                            reference = "L",intercept = TRUE, voom_method = FALSE)
rmRNAseq:::pauc_out(diffExprs$pv, EE , DE)
diffExprs2 <- rmRNAseq:::my_splineDiffExprs(eSetObject = data, df = 3,cutoff.adj.pVal = 1,
reference = "L",intercept = TRUE, voom_method = TRUE)
rmRNAseq:::pauc_out(diffExprs2$pv, EE , DE)
}
