% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multtest.R
\name{estimate.m0}
\alias{estimate.m0}
\title{Estimate Number of True Null Hypotheses Using Histogram-based Method}
\usage{
estimate.m0(p, B = 20)
}
\arguments{
\item{p}{a numerical vector of p-value}

\item{B}{number of bin}
}
\value{
The function returns an estimate of m0, the number of tests for which
  the null hypothesis is true.
}
\description{
This function estimates the number of true null hypotheses given a vector of
p-values using the method of Nettleton et al. (2006) JABES 11, 337-356. The
estimate obtained is identical to the estimate obtained by the iterative
procedure described by Mosig et al. Genetics 157:1683-1698. The number of
p-values falling into B equally sized bins are counted. The count of each bin
is compared to the average of all the bin counts associated with the current
bins and all bins to its right.  Working from left to right, the first bin
that has a count less than or equal to the average is identified. That
average is multiplied by the total number of bins to obtain an estimate of
m0, the number of tests for which the null hypothesis is true.
}
\examples{
data(res)
p <- res$pqvalue$pv$line2
m0 <- rmRNAseq:::estimate.m0(p)
m0
}
\references{
1. Dan Nettleton, J. T. Gene Hwang, Rico A. Caldo and Roger P.
  Wise. Estimating the Number of True Null Hypotheses from a Histogram of p
  Values. Journal of Agricultural, Biological, and Environmental Statistics
  Vol. 11, No. 3 (Sep., 2006), pp. 337-356.
}
\author{
Dan Nettleton \email{dnett@iastate.edu}
}
