% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{makeInteractTrack}
\alias{makeInteractTrack}
\title{Export predicted gene-pair interaction}
\usage{
makeInteractTrack(corr.mat, genes.list, output_path, path_to_coords)
}
\arguments{
\item{corr.mat}{A sparse matrix with peak names as rows and gene symbols as columns.}

\item{genes.list}{A list of the genes symbols to be tested. If not specified,
this function will use all the gene symbols from the matrix passed to gmat by default.}

\item{output_path}{Path in which the output file will be stored.}

\item{path_to_coords}{Path to the gene coordinates file.}
}
\value{
An Interact Track file stored in the specified path.
}
\description{
Export the predicted gene-pair interactions calculated by upstream function 'linkGenesAndPeaks'
 into an Interact Track file which is compatible with UCSC Genome Browser.
}
\examples{
\dontrun{
# Only runable for ATAC datasets, see tutorial on GitHub
# some gene-peak correlation matrix: regent
makeInteractTrack(regnet, path_to_coords = 'some_path_to_gene_coordinates/hg19_genes.bed')
}
}
