% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{type-predicates}
\alias{type-predicates}
\alias{is_list}
\alias{is_atomic}
\alias{is_vector}
\alias{is_integer}
\alias{is_double}
\alias{is_character}
\alias{is_logical}
\alias{is_raw}
\alias{is_bytes}
\alias{is_null}
\title{Type predicates}
\usage{
is_list(x, n = NULL)

is_atomic(x, n = NULL)

is_vector(x, n = NULL)

is_integer(x, n = NULL)

is_double(x, n = NULL, finite = NULL)

is_character(x, n = NULL, encoding = NULL)

is_logical(x, n = NULL)

is_raw(x, n = NULL)

is_bytes(x, n = NULL)

is_null(x)
}
\arguments{
\item{x}{Object to be tested.}

\item{n}{Expected length of a vector.}

\item{finite}{Whether values must be finite. Examples of non-finite
values are \code{Inf}, \code{-Inf} and \code{NaN}.}

\item{encoding}{Expected encoding of a string or character
vector. One of \code{UTF-8}, \code{latin1}, or \code{unknown}.}
}
\description{
These type predicates aim to make type testing in R more
consistent. They are wrappers around \code{\link[base:typeof]{base::typeof()}}, so operate
at a level beneath S3/S4 etc.
}
\details{
Compared to base R functions:
\itemize{
\item The predicates for vectors include the \code{n} argument for
pattern-matching on the vector length.
\item Unlike \code{is.atomic()}, \code{is_atomic()} does not return \code{TRUE} for
\code{NULL}.
\item Unlike \code{is.vector()}, \code{is_vector()} test if an object is an
atomic vector or a list. \code{is.vector} checks for the presence of
attributes (other than name).
}
}
\seealso{
\link{bare-type-predicates} \link{scalar-type-predicates}
}
