% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskyr_class.R
\name{plot.riskyr}
\alias{plot.riskyr}
\title{Plot information of a riskyr object.}
\usage{
\method{plot}{riskyr}(x = NULL, plot.type = "network", ...)
}
\arguments{
\item{x}{An object of class "riskyr", usually a result of a call to \code{\link{riskyr}}.
Pre-defined \code{\link{scenarios}} are also of type "riskyr".}

\item{plot.type}{The type of plot to be generated.

\enumerate{

  \item \code{plot.type = "fnet"} or \code{plot.type = "network"}:
  Risk information is plotted in a network diagram of frequencies and probabilities (default).
  See \code{\link{plot_fnet}} for further options.

  \item \code{plot.type = "ftree"} or \code{plot.type = "ftree"}:
  Risk information is plotted in a frequency tree.
  See \code{\link{plot_tree}} for further options.

  \item \code{plot.type = "icons"} or \code{plot.type = "iconarray"}:
  The underlying population is plotted as icons.
  See \code{\link{plot_icons}} for further options.

  \item \code{plot.type = "mosaic"} or \code{plot.type = "mosaicplot"}:
  Risk information is plotted as a mosaicplot.
  See \code{\link{plot_mosaic}} for further options.

  \item \code{plot.type = "curve"} or \code{plot.type = "curves"}:
  Draws curves of selected values (including \code{\link{PPV}}, \code{\link{NPV}})
  See \code{\link{plot_curve}} for further options.

  \item \code{plot.type = "plane"} or \code{plot.type = "planes"}:
  Draws a 3D-plane of selected values (e.g., predictive values \code{\link{PPV}} or \code{\link{NPV}})
  See \code{\link{plot_plane}} for further options.
}}

\item{...}{Additional parameters to be passed to the
underlying plotting functions.}
}
\description{
\code{plot.riskyr} is a method that allows to generate
different plot types from a \code{"riskyr"} object.
}
\details{
\code{plot.riskyr} also uses the text settings
specified in the "riskyr" object.
}
\examples{
# Select a scenario from list of scenarios:
s25 <- scenarios$n25  # select scenario 25 from scenarios

# Plot different types:
plot(s25)  # => default plot (fnet)
plot(s25, plot.type = "fnet")  # => network diagram (same as default)
plot(s25, plot.type = "tree", area = "vr") # => tree diagram (with vertical rectangles)
plot(s25, plot.type = "curve", what = "all")
plot(s25, plot.type = "icons")
plot(s25, plot.type = "icons", type = "mosaic")  # passing on additional parameter to create.
plot(s25, plot.type = "mosaic")
plot(s25, plot.type = "plane", what = "NPV")


}
\seealso{
Other visualization functions: \code{\link{plot_curve}},
  \code{\link{plot_fnet}}, \code{\link{plot_icons}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_tree}}
}
