% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transformCI}
\alias{transformCI}
\title{Compute Confidence Intervals using a transformation}
\usage{
transformCI(estimate, se, quantile, type, min.value, max.value)
}
\arguments{
\item{estimate}{[numeric matrix] the estimate value before transformation.}

\item{se}{[numeric matrix] the standard error after transformation.}

\item{quantile}{[numeric vector] quantile that will be multiplied to each column of \code{se}.}

\item{type}{[character] the transforamtion.
Can be \code{"log"}, \code{"loglog"}, \code{"cloglog"}, or \code{"atanh"} (Fisher transform).}

\item{min.value}{[numeric] if not \code{NULL} and the lower bound of the confidence interval is below \code{min},
it will be set at \code{min}.}

\item{max.value}{[numeric] if not \code{NULL} and the lower bound of the confidence interval is below \code{max},
it will be set at \code{max}.}
}
\description{
Compute confidence intervals using a transformation.
The resulting confidence interval is returned on the original case (i.e. back-transformed).
}
\details{
\code{se} and \code{estimate} must have same dimensions.
}
