% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven-spss.R
\name{read_spss}
\alias{read_spss}
\alias{read_sav}
\alias{read_por}
\alias{write_sav}
\title{Read and write SPSS files}
\usage{
read_sav(
  file,
  encoding = NULL,
  user_na = FALSE,
  col_select = NULL,
  skip = 0,
  n_max = Inf,
  .name_repair = "unique"
)

read_por(
  file,
  user_na = FALSE,
  col_select = NULL,
  skip = 0,
  n_max = Inf,
  .name_repair = "unique"
)

write_sav(data, path, compress = c("byte", "none", "zsav"), adjust_tz = TRUE)

read_spss(
  file,
  user_na = FALSE,
  col_select = NULL,
  skip = 0,
  n_max = Inf,
  .name_repair = "unique"
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, the input must be either wrapped with \code{I()}, be a string
containing at least one new line, or be a vector containing at least one
string with a new line.

Using a value of \code{\link[readr:clipboard]{clipboard()}} will read from the system clipboard.}

\item{encoding}{The character encoding used for the file. The default,
\code{NULL}, use the encoding specified in the file, but sometimes this
value is incorrect and it is useful to be able to override it.}

\item{user_na}{If \code{TRUE} variables with user defined missing will
be read into \code{\link[=labelled_spss]{labelled_spss()}} objects. If \code{FALSE}, the
default, user-defined missings will be converted to \code{NA}.}

\item{col_select}{One or more selection expressions, like in
\code{\link[dplyr:select]{dplyr::select()}}. Use \code{c()} or \code{list()} to use more than one expression.
See \code{?dplyr::select} for details on available selection options. Only the
specified columns will be read from \code{data_file}.}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of lines to read.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}

\item{data}{Data frame to write.}

\item{path}{Path to a file where the data will be written.}

\item{compress}{Compression type to use:
\itemize{
\item "byte": the default, uses byte compression.
\item "none": no compression. This is useful for software that has issues with
byte compressed \code{.sav} files (e.g. SAS).
\item "zsav": uses zlib compression and produces a \code{.zsav} file. zlib
compression is supported by SPSS version 21.0 and above.
}

\code{TRUE} and \code{FALSE} can be used for backwards compatibility, and correspond
to the "zsav" and "none" options respectively.}

\item{adjust_tz}{Stata, SPSS and SAS do not have a concept of time zone,
and all \link{date-time} variables are treated as UTC. \code{adjust_tz} controls
how the timezone of date-time values is treated when writing.
\itemize{
\item If \code{TRUE} (the default) the timezone of date-time values is ignored, and
they will display the same in R and Stata/SPSS/SAS, e.g.
\code{"2010-01-01 09:00:00 NZDT"} will be written as \code{"2010-01-01 09:00:00"}.
Note that this changes the underlying numeric data, so use caution if
preserving between-time-point differences is critical.
\item If \code{FALSE}, date-time values are written as the corresponding UTC value,
e.g. \code{"2010-01-01 09:00:00 NZDT"} will be written as
\code{"2009-12-31 20:00:00"}.
}}
}
\value{
A tibble, data frame variant with nice defaults.

Variable labels are stored in the "label" attribute of each variable.
It is not printed on the console, but the RStudio viewer will show it.

\code{write_sav()} returns the input \code{data} invisibly.
}
\description{
\code{read_sav()} reads both \code{.sav} and \code{.zsav} files; \code{write_sav()} creates
\code{.zsav} files when \code{compress = TRUE}. \code{read_por()} reads \code{.por} files.
\code{read_spss()} uses either \code{read_por()} or \code{read_sav()} based on the
file extension.
}
\details{
Currently haven can read and write logical, integer, numeric, character
and factors. See \code{\link[=labelled_spss]{labelled_spss()}} for how labelled variables in
SPSS are handled in R.
}
\examples{
path <- system.file("examples", "iris.sav", package = "haven")
read_sav(path)

tmp <- tempfile(fileext = ".sav")
write_sav(mtcars, tmp)
read_sav(tmp)
}
