% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{age.pMC}
\alias{age.pMC}
\title{Calculate pMC values from C14 ages}
\usage{
age.pMC(mn, sdev = c(), ratio = 100, decimals = 5, lambda = 8033)
}
\arguments{
\item{mn}{Reported mean of the 14C age.}

\item{sdev}{Reported error of the 14C age.}

\item{ratio}{Most modern-date values are reported against \code{100}. If it is against \code{1} instead, a warning is provided; use \code{age.F14C}.}

\item{decimals}{Amount of decimals required for the pMC value. Defaults to 5.}

\item{lambda}{The mean-life of radiocarbon (based on Libby half-life of 5568 years)}
}
\value{
pMC values from C14 ages.
}
\description{
Calculate pMC values from radiocarbon ages
}
\details{
Post-bomb dates are often reported as pMC or percent modern carbon. Since Bacon expects radiocarbon ages,
this function can be used to calculate pMC values from radiocarbon ages. The reverse function of \link{pMC.age}.
}
\examples{
  age.pMC(-2000, 20)
  age.pMC(-2000, 20, 1)
}
