% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{D14C.F14C}
\alias{D14C.F14C}
\title{Transform D14C into F14C}
\usage{
D14C.F14C(D14C, t)
}
\arguments{
\item{D14C}{The Delta14C value to translate}

\item{t}{the cal BP age}
}
\value{
The corresponding F14C value
}
\description{
Transform D14C into F14C
}
\details{
As explained by Heaton et al. 2020 (Radiocarbon), 14C measurements are commonly expressed in
three domains: Delta14C, F14C and the radiocarbon age. This function translates Delta14C, the historical level of Delta14C in the year t cal BP, to F14C values. Note that per convention, this function uses the Cambridge half-life, not the Libby half-life.
}
\examples{
D14C.F14C(-10, 238)
}
