% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idig_search.R
\name{idig_search}
\alias{idig_search}
\title{Basic searching of iDigBio records}
\usage{
idig_search(type = "records", mq = FALSE, rq = FALSE, fields = FALSE,
  max_items = 1e+05, limit = 0, offset = 0, sort = FALSE, ...)
}
\arguments{
\item{type}{string type of records to query, defaults to "records"}

\item{mq}{iDigBio media query in nested list format}

\item{rq}{iDigBio record query in nested list format}

\item{fields}{vector of fields that will be contained in the data.frame}

\item{max_items}{CURRENTLY IGNORED, SEE ISSUE #33 maximum number of results 
allowed to be retrieved (fail-safe)}

\item{limit}{maximum number of results returned}

\item{offset}{number of results to skip before returning results}

\item{sort}{vector of fields to use for sorting, UUID is always appended to
make paging safe}

\item{...}{additional parameters}
}
\value{
a data frame
}
\description{
Base function to query the iDigBio API
}
\details{
This function is wrapped for media and specimen record searches. Please
consider using \code{\link{idig_search_media}} or
\code{\link{idig_search_records}} instead as they supply nice defaults to
this function depending on the type of records desired.

Fuller documentation of parameters is in the
\code{\link{idig_search_records}} function's help.

Exported to facilitate wrapping this package in other packages.
}
\examples{
\dontrun{
# Ten media records related to genus Acer specimens
idig_search(type="media", rq=list(genus="acer"), limit=10)
}

}
\author{
Francois Michonneau
}
