% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials.R
\name{create_material}
\alias{create_material}
\title{Create a new material}
\usage{
create_material(
  course_id = NULL,
  topic_id = NULL,
  publish = FALSE,
  title = NULL,
  description = NULL,
  link = NULL
)
}
\arguments{
\item{course_id}{Course id of where to make the new materials. Can find from end of URL e.g. "https://classroom.google.com/c/COURSE_ID_IS_HERE"}

\item{topic_id}{topic ID to be looked for.}

\item{publish}{TRUE/FALSE, automatically publish the coursework upon posting? Default is to be posted as a draft (students will not see it until you click Post).}

\item{title}{Name of new material}

\item{description}{A description for the new material}

\item{link}{A URL to go with the associated material}
}
\description{
Create a new material
}
\examples{
\dontrun{
course_id <- get_course_list()$courses$id[3]
topic_id <- get_topic_list(course_id)$topic$topicId[1]

create_material(course_id, topic_id, title = "new material")
}
}
