\name{write.gexf}
\alias{write.gexf}
\title{Builds a graph of \code{gexf} class}
\description{\code{write.gexf} takes a \code{node} matrix (or dataframe) and an \code{edge} matrix (or dataframe) and creates a \code{gexf} object containing a data-frame representation and a gexf representation of a graph.}
\usage{
write.gexf(
  nodes, edges, edgesLabel = NULL, edgesId = NULL,
  edgesAtt = NULL, edgesWeight = NULL, 
  edgesVizAtt = list(
    color=NULL, 
    size=NULL, 
    shape=NULL
  ),
  nodesAtt = NULL,
  nodesVizAtt = list(
    color=NULL, 
    position=NULL, 
    size=NULL, 
    shape=NULL, 
    image=NULL
  ),
  nodeDynamic = NULL, 
  edgeDynamic = NULL, 
  output = NA, tFormat = "double", 
  defaultedgetype = "undirected",
  meta = list(
    creator="NodosChile", 
    description="A graph file writing in R using \"rgexf\"",
    keywords="gexf graph, NodosChile, R, rgexf"),
  keepFactors = TRUE
  )
}
\arguments{
  \item{nodes}{A two-column data-frame or matrix of \dQuote{id}s and \dQuote{label}s representing nodes.}
  \item{edges}{A two-column data-frame or matrix containing \dQuote{source} and \dQuote{target} for each edge. Source and target values are based on the nodes ids.}
  \item{edgesId}{A one-column data-frame, matrix or vector.}
  \item{edgesLabel}{A one-column data-frame, matrix or vector.}
  \item{edgesAtt}{A data-frame with one or more columns representing edges' attributes.}
  \item{edgesWeight}{A numeric vector containing edges' weights.}
  \item{edgesVizAtt}{List of three or less viz attributes such as color, size (thickness) and shape of the edges (see details)}
  \item{nodesAtt}{A data-frame with one or more columns representing nodes' attributes}
  \item{nodesVizAtt}{List of four or less viz attributes such as color, position, size and shape of the nodes (see details)}
  \item{nodeDynamic}{A two-column matrix or data-frame. The first column indicates the time at which a given node starts; the second one shows when it ends. The matrix or data-frame must have the same number of rows than the number of nodes in the graph.}
  \item{edgeDynamic}{A two-column matrix or data-frame. The fist column indicates the time at which a given edge stars; the second one shows when it ends. The matrix or dataframe must have the same number of rows than the number of edges in the graph.}
  \item{output}{String. The complete path (including filename) where to export the graph as a GEXF file.}
  \item{tFormat}{String. Time format for dynamic graphs (see details)}
  \item{defaultedgetype}{\dQuote{directed}, \dQuote{undirected}, \dQuote{mutual}}
  \item{meta}{A List. Meta data describing the graph}
  \item{keepFactors}{Logical, whether to handle factors as numeric values (\code{TRUE}) or as strings (\code{FALSE}) by using \code{as.character}.}
}
\details{  
  Just like \code{nodesVizAtt} and \code{edgesVizAtt}, \code{nodesAtt} and \code{edgesAtt} must have the same number of rows as nodes and edges, respectively. Using data frames is necessary as in this way data types are preserved.
  
  \code{nodesVizAtt} and \code{edgesVizAtt} allow using visual attributes such as color, position (nodes only), size (nodes only), thickness (edges only) shape and image (nodes only). 
  \itemize{
  \item Color is defined by the RGBA color model, thus for every node/edge the color should be specified through a data-frame with columns \emph{r} (red), \emph{g} (green), \emph{b} (blue) with integers between 0 and 256 and a last column with \emph{alpha} values as a float between 0.0 and 1.0.
  \item Position, for every node, it is a three-column data-frame including \emph{x}, \emph{y} and \emph{z} coordinates. The three components must be float.
  \item Size as a numeric colvector (float values).
  \item Thickness (see size).
  \item Node Shape (string), currently unsupported by Gephi, can take the values of \emph{disk}, \emph{square}, \emph{triangle}, \emph{diamond} and \emph{image}.
  \item Edge Shape (string), currently unsuported by Gephi, can take the values of \emph{solid}, \emph{dotted}, \emph{dashed} and \emph{double}.
  \item Image (string), currently unsupported by Gephi, consists on a vector of strings representing URIs.
  }
  
  \code{nodeDynamic} and \code{edgeDynamic} allow to draw dynamic graphs. It should contain two columns \emph{start} and \emph{end}, both allowing \code{NA} value. It can be use jointly with \code{tFormat} which by default is setted as \dQuote{double}. Currently accepted time formats are:
  \itemize{
  \item Integer or double.
  \item International standard \emph{date} yyyy-mm-dd.
  \item dateTime W3 XSD (\url{http://www.w3.org/TR/xmlschema-2/#dateTime}).
  }
}
\value{
  A \code{gexf} class object (list). Contains the following:
  \itemize{
  \item \code{meta} : (list) Meta data describing the graph.
  \item \code{mode} : (list) Sets the default edge type and the graph mode.
  \item \code{atts.definitions}: (list) Two data-frames describing nodes and edges
  attributes.
  \item \code{nodesVizAtt} : (data-frame) A multi-column data-frame with the nodes' visual attributes.
  \item \code{edgesVizAtt} : (data-frame) A multi-column data-frame with the edges' visual attributes.
  \item \code{nodes} : (data-frame) A two-column data-frame with nodes' ids and labels.
  \item \code{edges} : (data-frame) A five-column data-frame with edges' ids, labels,
  sources, targets and weights.
  \item \code{graph} : (String) GEXF (XML) representation of the graph.
  }
}
\author{George Vega Yon \email{george.vega@nodoschile.org},

Jorge Fabrega Lacoa \email{jorge.fabrega@nodoschile.org}}

\references{
  The GEXF project website:
  \url{http://gexf.net} 
}
\seealso{
  \code{\link{new.gexf.graph}}
}
\examples{
  \dontrun{
  demo(gexf) # Example of gexf command using fictional data.
  demo(gexfattributes) # Working with attributes.
  demo(gexfbasic) # Basic net.
  demo(gexfdynamic) # Dynamic net.
  demo(edge.list) # Working with edges lists.
  demo(gexffull) # All the package.
  demo(gexftwitter) # Example with real data of chilean twitter accounts.
  demo(gexfdynamicandatt) # Dynamic net with static attributes.
  demo(gexfbuildfromscratch) # Example building a net from scratch.
  }
}
\keyword{ IO }
