% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genie_functions.R
\docType{package}
\name{rgenie}
\alias{rgenie}
\title{rgenie: Analysis of GenIE experiments}
\description{
rgenie is a package to analyze the next-generation sequencing output from a
set of GenIE experimental replicates.
}
\details{
GenIE (genome-editing interrogation of enhancers) is an experimental method
to evaluate the effects of individual SNPs on gene transcription. It is based
on targeted CRISPR-Cas9 genome editing in cultured cells to produce indels at
a target locus, optionally with a homology-dependent recombination (HDR)
construct to create precisely defined genomic changes. Following this, both
genomic DNA (gDNA) and RNA are extracted from the same pool of cells, and
then cDNA is generated. Both gDNA and cDNA are amplified with locus-specific
PCR primers, in multiple replicates, and libraries of the experimental
replicates are prepared for next-generation sequencing. The sequencing data
from each replicate for each region should be aligned to either the full
reference genome or to a locus-specific (amplicon) reference genome for
analysis by rgenie.
}
\section{rgenie analyses}{
 Two types of analyses can be run with rgenie: a
  grep-based analysis, which uses pattern matching to identify HDR vs.
  wild-type (WT) reads, and an alignment-based analysis, which uses all
  Cas9-generated alleles, including deletions. The analysis is run for a
  given \strong{region}, which must have multiple \strong{replicates} for
  both cDNA and gDNA. These analyses take as input a data.frame defining the
  region, and a data.frame defining replicates.

  The result of an rgenie analysis is a list object with multiple tables,
  which depend on whether a grep or deletion analyses was done. Plotting
  functions take as input the result of one of these main rgenie analyses.
}

\seealso{
\code{\link{grep_analysis}}

\code{\link{deletion_analysis}}
}
