% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datasets.r
\name{datasets}
\alias{datasets}
\title{Search for datasets and dataset metadata.}
\usage{
datasets(data = "all", type = NULL, uuid = NULL, query = NULL,
  id = NULL, limit = 100, start = NULL, ...)
}
\arguments{
\item{data}{The type of data to get. Default is all data.}

\item{type}{Type of dataset, options include OCCURRENCE, etc.}

\item{uuid}{UUID of the data node provider. This must be specified if data
is anything other than 'all'.}

\item{query}{Query term(s). Only used when data='all'}

\item{id}{A metadata document id.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination with \code{limit} to
page through results.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\value{
A list.
}
\description{
Search for datasets and dataset metadata.
}
\examples{
\dontrun{
datasets(limit=5)
datasets(type="OCCURRENCE")
datasets(uuid="a6998220-7e3a-485d-9cd6-73076bd85657")
datasets(data='contact', uuid="a6998220-7e3a-485d-9cd6-73076bd85657")
datasets(data='metadata', uuid="a6998220-7e3a-485d-9cd6-73076bd85657")
datasets(data='metadata', uuid="a6998220-7e3a-485d-9cd6-73076bd85657", id=598)
datasets(data=c('deleted','duplicate'))
datasets(data=c('deleted','duplicate'), limit=1)

# httr options
library('httr')
res <- datasets(data=c('deleted','duplicate'), config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/registry#datasets}
}

