\docType{package}
\name{rgbif}
\alias{rgbif}
\alias{rgbif-package}
\title{rgbif: A programmatic interface to the Web Service methods provided by the
Global Biodiversity Information Facility.}
\description{
rgbif: A programmatic interface to the Web Service methods
provided by the Global Biodiversity Information Facility.
}
\section{About}{
  This package gives you access to data from GBIF
  \url{http://www.gbif.org/} via their API.
}

\section{Transitioning to the new GBIF API}{
  Note that development is rapid at this point so expect
  changes, but changes should slow down with time...

  The old GBIF API

  \itemize{ \item See documentation here
  \url{http://data.gbif.org/tutorial/services} }

  The new GBIF API

  \itemize{ \item See documentation here:
  \url{http://www.gbif.org/developer/summary} }

  The functions for the old GBIF API give deprecation
  messages, signaling that they are on their way out. A
  future version of \code{rgbif} will remove functions for
  the old API, so do transition to the functions for the
  new API soon.

  The new GBIF API only uses JSON as a data format - no
  more XML. Of course this probably doesn't matter to you
  unless you are a hacker...
}

\section{Function changes}{
  Changes in the new GBIF API from last with respect to
  rgbif, the first column giving the function name, the
  second column giving the state of the function in the new
  package version, and any reasoning in the third column.

  \tabular{lll}{ rgb_country_codes \tab same \tab none \cr
  density_spplist \tab deprecated \tab service no longer
  provided \cr densitylist \tab deprecated \tab service not
  provided anymore \cr gbifdata \tab deprecated \tab not
  needed \cr gbifmap_dens \tab deprecated \tab none \cr
  gbifmap_list \tab deprecated \tab none \cr is.gbifdens
  \tab deprecated \tab none \cr is.gbiflist \tab deprecated
  \tab none \cr networks \tab same \tab some parameters
  differ \cr occurrencecount \tab occ_count \tab some
  parameters differ \cr occurrencedensity \tab deprecated
  \tab service not provided anymore \cr occurrenceget \tab
  occ_get \tab none \cr occurrencelist \tab occ_search \tab
  none \cr occurrencelist_all \tab occ_search \tab none \cr
  occurrencelist_many \tab occ_search \tab none \cr
  providers \tab deprecated \tab see note 1 \cr resources
  \tab deprecated \tab see note 1 \cr stylegeojson \tab
  same \tab not implemented yet \cr taxoncount \tab
  deprecated \tab See ?occ_count \cr taxonget \tab
  deprecated \tab See ?name_lookup \cr taxonsearch \tab
  deprecated \tab See note 2 \cr taxrank \tab same \tab
  none \cr togeojson \tab same \tab not implemented yet }

  Note 1: See \code{\link{datasets}},
  \code{\link{networks}}, \code{\link{nodes}}, and
  \code{\link{organizations}}

  Note 2: See \code{\link{name_lookup}} for names across
  all of GBIF and \code{\link{name_backbone}} for names
  only in the GBIF backbone taxonomy.
}

