% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-statistics.R
\docType{methods}
\name{cov,ml.col.def,ml.col.def-method}
\alias{cov,ml.col.def,ml.col.def-method}
\title{Covariance}
\usage{
\S4method{cov}{ml.col.def,ml.col.def}(x, y = NULL, use = NULL,
  method = NULL)
}
\arguments{
\item{x}{a ml.data.frame field.}

\item{y}{a ml.data.frame field}

\item{use}{not implemented}

\item{method}{not implemented}
}
\value{
The sample covariance
}
\description{
Returns the sample covariance of two variables, \link{ml.data.frame} fields.
}
\details{
The function eliminates all pairs for which either the first element or the second
element is empty. After the elimination, if the length of the input is less than 2,
the function returns the empty sequence.
}
\examples{
\dontrun{
 library(rfml)
 locConn <- ml.connect()
 # create a ml.data.frame based on a search
 mlIris <- ml.data.frame(locConn,collection = "iris")
 # return the Covariance
 cov(mlIris$Sepal.Length, mlIris$Petal.Length)
}
}

