% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_csv.R
\name{read_csv}
\alias{read_csv}
\title{Read csv file}
\usage{
read_csv(file, id = NULL, doi = NULL, dataset_bibentry = NULL, ...)
}
\arguments{
\item{file}{A path to a file to import.}

\item{id}{An identifier of the tibble, if omitted, defaults to the
file name without its extension.}

\item{doi}{An optional document object identifier.}

\item{dataset_bibentry}{A bibliographic entry created with
\code{dataset::\link[dataset:dublincore]{dublincore}} or
\code{dataset::\link[dataset:datacite]{datacite}}.}

\item{...}{Further optional parameters to pass on to
\code{utils::\link[utils:read.csv]{read.csv}}.}
}
\value{
A tibble, data frame variant with survey attributes.
}
\description{
Import a survey from a csv file.
}
\examples{
# Create a temporary CSV file:
path <- system.file("examples", "ZA7576.rds", 
                    package = "retroharmonize")
read_survey <- read_rds(path)
test_csv_file <- tempfile()
write.csv(x = read_survey, 
          file = test_csv_file, 
          row.names = FALSE)
         
# Read the CSV file:
re_read <- read_csv(
  file = test_csv_file,
  id = "ZA7576", 
  doi = "test_doi"
)
}
\seealso{
Other import functions: 
\code{\link{harmonize_survey_variables}()},
\code{\link{pull_survey}()},
\code{\link{read_dta}()},
\code{\link{read_rds}()},
\code{\link{read_spss}()},
\code{\link{read_surveys}()}
}
\concept{import functions}
