% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_survey.R
\name{pull_survey}
\alias{pull_survey}
\title{Pull a survey from a survey list}
\usage{
pull_survey(survey_list, id = NULL, filename = NULL)
}
\arguments{
\item{survey_list}{A list of surveys}

\item{id}{The id of the requested survey. If \code{NULL} use 
\code{filename}}

\item{filename}{The filename of the requested survey.}
}
\value{
A single survey identified by \code{id} or \code{filename}.
}
\description{
Pull a survey by survey code or id.
}
\examples{
examples_dir <- system.file( "examples", package = "retroharmonize")

my_rds_files <- dir( examples_dir)[grepl(".rds", 
                                   dir(examples_dir))]

example_surveys <- read_surveys(
    file.path(examples_dir, my_rds_files) )

pull_survey(example_surveys, id = "ZA5913")
}
\seealso{
Other import functions: 
\code{\link{read_rds}()},
\code{\link{read_spss}()},
\code{\link{read_surveys}()},
\code{\link{subset_save_surveys}()}
}
\concept{import functions}
