% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etel.R
\name{etel}
\alias{etel}
\title{Exponentially tilted empirical likelihood}
\usage{
etel(fn, x, par, opts = NULL)
}
\arguments{
\item{fn}{An estimating function that takes the data \code{x} and parameter value
\code{par} as its arguments, returning a numeric matrix. Each row is the return
value from the corresponding row in \code{x}.}

\item{x}{A numeric matrix, or an object that can be coerced to a numeric
matrix. Each row corresponds to an observation. The number of rows must be
greater than the number of columns.}

\item{par}{A numeric vector of parameter values to be tested.}

\item{opts}{An optional list with optimization options for \code{\link[=nloptr]{nloptr()}}.
Defaults to \code{NULL}.}
}
\value{
A single numeric value representing the log-likelihood ratio. It contains
the optimization results as the attribute \code{optim}.
}
\description{
Computes exponentially tilted empirical likelihood.
}
\examples{
# Generate data
set.seed(63456)
x <- rnorm(100)

# Define an estimating function (ex. mean)
fn <- function(x, par) {
  x - par
}

# Set parameter value
par <- 0

# Call the etel function
etel(fn, x, par)
}
\references{
Schennach, SM (2005).
"Bayesian Exponentially Tilted Empirical Likelihood."
\emph{Biometrika}, 92, 31--46.
}
