% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_metadata.R
\name{gen_metadata_variable}
\alias{gen_metadata_variable}
\title{gen_metadata_variable}
\usage{
gen_metadata_variable(
  code = NULL,
  database = c("all", "genesis", "zensus", "regio"),
  area = c("all", "public", "user"),
  error.ignore = FALSE,
  verbose = TRUE,
  raw = FALSE,
  ...
)
}
\arguments{
\item{code}{A character string with a maximum length of 15 characters. Code from a GENESIS, Zensus 2022 or regionalstatistik.de object. Only one code per iteration.}

\item{database}{Character string. Indicator if the GENESIS ('genesis'), Zensus 2022 ('zensus') or regionalstatistik.de ('regio') database is called. Default option is 'all'.}

\item{area}{Character string. Indicator from which area of the database the results are called. In general, 'all' is the appropriate solution. Default option is 'all'. Not used for 'statistics'.}

\item{error.ignore}{Boolean. Indicator if the function should stop if an error occurs or no object for the request is found or if it should produce a token as response. Default option is 'FALSE'.}

\item{verbose}{Boolean. Indicator if the output of the function should include detailed messages and warnings. Default option is 'TRUE'. Set the parameter to 'FALSE' to suppress additional messages and warnings.}

\item{raw}{Boolean. Should a non-parsed API response be returned? Default option is 'FALSE'.}

\item{...}{Additional parameters for the API call. These parameters are only affecting the call itself, no further processing. For more details see \code{vignette("additional_parameter")}.}
}
\value{
A list with all recalled elements from the API. Attributes are added to the data.frame describing the search configuration for the returned output.
}
\description{
Function to search for meta information for a specific variable.
}
\examples{
\dontrun{
# Find meta-information of the variable with the code "FAMSTD"
object <- gen_metadata_var(code = "FAMSTD")
}

}
