% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sdp.R
\name{sdp}
\alias{sdp}
\title{Stochastic Dynamic Programming (Deprecated function; use 'sdp_supply' instead)}
\usage{
sdp(Q, capacity, target, S_disc = 1000, R_disc = 10, Q_disc = c(0, 0.2375,
  0.475, 0.7125, 0.95, 1), loss_exp = 2, S_initial = 1, plot = TRUE,
  tol = 0.99, rep_rrv = FALSE)
}
\arguments{
\item{Q}{time series object. Net inflows to the reservoir.}

\item{capacity}{numerical. The reservoir storage capacity (must be the same volumetric unit as Q and the target release).}

\item{target}{numerical. The target release constant.}

\item{S_disc}{integer. Storage discretization--the number of equally-sized storage states. Default = 1000.}

\item{R_disc}{integer. Release discretization. Default = 10 divisions.}

\item{Q_disc}{vector. Inflow discretization bounding quantiles. Defaults to five inflow classes bounded by quantile vector c(0.0, 0.2375, 0.4750, 0.7125, 0.95, 1.0).}

\item{loss_exp}{numeric. The exponent of the penalty cost function--i.e., Cost[t] <- ((target - release[t]) / target) ^ **loss_exp**). Default value is 2.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{tol}{numerical. The tolerance for policy convergence. The default value is 0.990.}

\item{rep_rrv}{logical. If TRUE then reliability, resilience and vulnerability metrics are computed and returned.}
}
\value{
Returns a list that includes: the optimal policy as an array of release decisions dependent on storage state, month/season, and current-period inflow class; the Bellman cost function based on storage state, month/season, and inflow class; the optimized release and storage time series through the training inflow data; the flow discretization (which is required if the output is to be implemented in the rrv function); and, if requested, the reliability, resilience, and vulnerability of the system under the optimized policy.
}
\description{
Derives the optimal release policy based on storage state, inflow class and within-year period.
}
\references{
Loucks, D.P., van Beek, E., Stedinger, J.R., Dijkman, J.P.M. and Villars, M.T. (2005) Water resources systems planning and management: An introduction to methods, models and applications. Unesco publishing, Paris, France.

Gregory R. Warnes, Ben Bolker and Thomas Lumley (2014). gtools: Various R programming tools. R package version 3.4.1. http://CRAN.R-project.org/package=gtools
}
\seealso{
\code{\link{sdp}} for deterministic Dynamic Programming
}

