% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_search.R
\name{global_search}
\alias{global_search}
\title{global_search}
\usage{
global_search(query, server_list, which_service)
}
\arguments{
\item{query}{(character) Search terms}

\item{server_list}{(list of character) List of ERDDAP servers to search}

\item{which_service}{(character) One of tabledep or griddap.}
}
\value{
If successful a dataframe wih columns:
\itemize{
\item title - the dataset title
\item dataset_id - the datasetid on that ERDDAP server
\item url - base url of dataset ERDDAP server
}
if urls are valid,  no match is found,  will return no match found
else returns error message
}
\description{
Search for ERDDAP tabledap or griddap datasets from a list
of ERDDAP servers based on search terms.
}
\details{
Uses the 'reddap' function ed_search() to search over
the list of servers
}
\examples{
# get list of servers know by
# https://irishmarineinstitute.github.io/awesome-erddap
# e_servers <- servers()$url
# select a couple to search
# e_servers <- e_servers[c(1, 40)]
# to meet CRAN time limits will only search 1 place
e_servers <- "https://coastwatch.pfeg.noaa.gov/erddap/"
test_query <- 'NOAA/NCDC Blended Monthly'
query_results <- global_search(test_query, e_servers, "griddap")
}
\seealso{
\code{\link[crul]{HttpClient}}
}
