% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Reggio15SSM}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Reggio15SSM}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Reggio15SSM data illustrate correlations between
results from individual participants in a family of two cross-over experiments conducted by
Reggio et al:
[1] G. Reggio, F. Ricca, G. Scanniello, F. D. Cerbo, and G. Dodero,"On the comprehension of
workflows modeled with a precise style: results from a family of controlled experiments".
Software and Systems Modeling, vol. 14, pp. 1481–1504, 2015.
The experiments assess whether the level of formality/precision in workflow model influences
comprehension.
If you use this data set please cite:
[1] G. Reggio, F. Ricca, G. Scanniello, F. D. Cerbo, and G. Dodero, "On the comprehension of
workflows modeled with a precise style: results from a family of controlled experiments".
Software and Systems Modeling, vol. 14, pp. 1481–1504, 2015.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The Importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).}
\format{
A data frame with 78 rows and 9 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each of the three experiments
in the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A , B , C, D}
\item{System}{<fct>|Software systems used in the experiment: PO, a system to process orders for
an online shop. DM, a system to manage an online document review process.}
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct>|Experimental Treatment: }
\item{Comprehension}{<dbl>|Dependent variable: The comprehension level obtained by each
participant.}
\item{Time}{<dbl>|Dependent variable: The time [min] taken by each participant to complete the
comprehension task.}
\item{CrossOverID}{<fct>|CrossOver category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. For a 2 group crossover,
the category is set to CO1 only}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Reggio15SSM
}
\description{
KitchenhamEtAl.CorrelationsAmongParticipants.Reggio15SSM data illustrate correlations between
results from individual participants in a family of two cross-over experiments conducted by
Reggio et al:
[1] G. Reggio, F. Ricca, G. Scanniello, F. D. Cerbo, and G. Dodero,"On the comprehension of
workflows modeled with a precise style: results from a family of controlled experiments".
Software and Systems Modeling, vol. 14, pp. 1481–1504, 2015.
The experiments assess whether the level of formality/precision in workflow model influences
comprehension.
If you use this data set please cite:
[1] G. Reggio, F. Ricca, G. Scanniello, F. D. Cerbo, and G. Dodero, "On the comprehension of
workflows modeled with a precise style: results from a family of controlled experiments".
Software and Systems Modeling, vol. 14, pp. 1481–1504, 2015.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The Importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Reggio15SSM

}
\keyword{datasets}
