% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.bayesfactor_models.R
\name{report.bayesfactor_models}
\alias{report.bayesfactor_models}
\alias{report.bayesfactor_inclusion}
\title{Reporting Models' Bayes Factor}
\usage{
\method{report}{bayesfactor_models}(
  x,
  interpretation = "jeffreys1961",
  exact = TRUE,
  protect_ratio = TRUE,
  ...
)

\method{report}{bayesfactor_inclusion}(
  x,
  interpretation = "jeffreys1961",
  exact = TRUE,
  protect_ratio = TRUE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{bayesfactor_inclusion}.}

\item{interpretation}{Effect size interpretation set of rules (see
\link[effectsize:interpret_bf]{interpret_bf}).}

\item{exact}{Should very large or very small values be reported with a
scientific format (e.g., 4.24e5), or as truncated values (as "> 1000" and
"< 1/1000").}

\item{protect_ratio}{Should values smaller than 1 be represented as ratios?}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link[=report]{report()}}.
}
\description{
Create reports of Bayes factors for model comparison.
}
\examples{
library(report)

mo0 <- lm(Sepal.Length ~ 1, data = iris)
mo1 <- lm(Sepal.Length ~ Species, data = iris)
mo2 <- lm(Sepal.Length ~ Species + Petal.Length, data = iris)
mo3 <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)

if (require("bayestestR")) {
  # Bayes factor - models
  BFmodels <- bayesfactor_models(mo1, mo2, mo3, denominator = mo0)

  r <- report(BFmodels)
  r
  as.data.frame(r)

  # Bayes factor - inclusion
  inc_bf <- bayesfactor_inclusion(BFmodels, prior_odds = c(1, 2, 3), match_models = TRUE)

  r <- report(inc_bf)
  r
  as.data.frame(r)
}
}
\seealso{
Specific components of reports (especially for stats models):
\itemize{
\item \code{\link[=report_table]{report_table()}}
\item \code{\link[=report_parameters]{report_parameters()}}
\item \code{\link[=report_statistics]{report_statistics()}}
\item \code{\link[=report_effectsize]{report_effectsize()}}
\item \code{\link[=report_model]{report_model()}}
\item \code{\link[=report_priors]{report_priors()}}
\item \code{\link[=report_random]{report_random()}}
\item \code{\link[=report_performance]{report_performance()}}
\item \code{\link[=report_info]{report_info()}}
\item \code{\link[=report_text]{report_text()}}
}
Other types of reports:
\itemize{
\item \code{\link[=report_system]{report_system()}}
\item \code{\link[=report_packages]{report_packages()}}
\item \code{\link[=report_participants]{report_participants()}}
\item \code{\link[=report_sample]{report_sample()}}
\item \code{\link[=report_date]{report_date()}}
}
Methods:
\itemize{
\item \code{\link[=as.report]{as.report()}}
}
Template file for supporting new models:
\itemize{
\item \code{\link[=report.default]{report.default()}}
}
}
