% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ao_data}
\alias{ao_data}
\title{Actor-Oriented Relational Event History}
\format{
\code{ao_data} is a list object containing the following objects:
\describe{
   \item{\code{edgelist}}{a \code{data.frame} with the raw simulated edgelist. The columns of the \code{data.frame} are:
           \describe{
               \item{\code{time}}{the timestamp indicating the time at which each event occurred}
               \item{\code{actor1}}{the actor that generated the relational event}
               \item{\code{actor2}}{the actor that received the relational event}
           }}
   \item{\code{seed}}{the seed value used in \code{remulate::remulateActor()} for generating the event sequence}
   \item{\code{true.pars}}{a list of two vectors named \code{"rate_model"} and \code{"choice_model"}, each containing the values of the parameters used in the generation of the event sequence}
    }
}
\usage{
data(ao_data)
}
\description{
A randomly generated sequence of relational events with 5 actors and 100 events. The event sequence is generated by following an actor-oriented modeling approach (for more information on the algorithm used for the generation, refer to \code{help(topic = remulateActor, package = "remulate")} or \code{?remulate::remulateActor}).
}
\examples{

# (1) load the data into the workspace
data(ao_data)

# (2) process event sequence with \code{remify}
ao_reh <- remify::remify(edgelist = ao_data$edgelist, model = "actor")

# (3) define linear predictor and claculate stastistcs with \code{remstats} package

## linear predictor for the rate model
rate_model <- ~ 1 + remstats::indegreeSender()

## linear predictror for the choice model
choice_model <- ~ remstats::inertia() + remstats::reciprocity()

## calculate statistics
ao_reh_stats <- remstats::remstats(reh = ao_reh, sender_effects = rate_model, 
receiver_effects = choice_model)

# (4) estimate model using method = "MLE" and print out summary

## estimate model
mle_ao <- remstimate::remstimate(reh = ao_reh, stats = ao_reh_stats, method = "MLE")

## print out a summary of the estimation
summary(mle_ao)

}
\keyword{datasets}
