% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-local.R
\name{install_local}
\alias{install_local}
\title{Install a package from a local file}
\usage{
install_local(path = ".", subdir = NULL, dependencies = NA,
  upgrade = c("default", "ask", "always", "never"), force = FALSE,
  quiet = FALSE, build = !is_binary_pkg(path),
  build_opts = c("--no-resave-data", "--no-manual",
  "--no-build-vignettes"), build_manual = FALSE,
  build_vignettes = FALSE, repos = getOption("repos"),
  type = getOption("pkgType"), ...)
}
\arguments{
\item{path}{path to local directory, or compressed file (tar, zip, tar.gz
tar.bz2, tgz2 or tbz)}

\item{subdir}{subdirectory within url bundle that contains the R package.}

\item{dependencies}{Which dependencies do you want to check?
Can be a character vector (selecting from "Depends", "Imports",
"LinkingTo", "Suggests", or "Enhances"), or a logical vector.

\code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
"Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
just check this package, not its dependencies).}

\item{upgrade}{One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}

\item{force}{Force installation, even if the remote state has not changed
since the previous install.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{build}{If \code{TRUE} build the package before installing.}

\item{build_opts}{Options to pass to \code{R CMD build}, only used when \code{build}}

\item{build_manual}{If \code{FALSE}, don't build PDF manual ('--no-manual').}

\item{build_vignettes}{If \code{FALSE}, don't build package vignettes ('--no-build-vignettes').
is \code{TRUE}.}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.}

\item{...}{Other arguments passed on to \code{\link[utils:install.packages]{utils::install.packages()}}.}
}
\description{
This function is vectorised so you can install multiple packages in
a single command.
}
\examples{
\dontrun{
dir <- tempfile()
dir.create(dir)
pkg <- download.packages("testthat", dir, type = "source")
install_local(pkg[, 2])
}
}
\seealso{
Other package installation: \code{\link{install_bioc}},
  \code{\link{install_bitbucket}},
  \code{\link{install_cran}}, \code{\link{install_dev}},
  \code{\link{install_github}},
  \code{\link{install_gitlab}}, \code{\link{install_git}},
  \code{\link{install_svn}}, \code{\link{install_url}},
  \code{\link{install_version}}
}
\concept{package installation}
